<?php
/**
 * Created by PhpStorm.
 * User: Jozell
 * Date: 12/11/2018
 * Time: 11:19 PM
 */

// UDP Client

// Reduce errors
error_reporting(~E_WARNING);

$server = "127.0.0.1";
$port = 8012;

// create a UDP Socket for client
if (!($sock = socket_create(AF_INET, SOCK_DGRAM, 0))) {
    $errorCode = socket_last_error();
    $errorMsg = socket_strerror($errorCode);

    die ("Couldn't create socket: [$errorCode] $errorMsg \n");
}

echo "Socket created \n";

// Bind sockets
socket_bind($sock, $server, $port);

// Communication loop
while(1) {
    // Take some input to send
    echo 'Enter a message to send: ';
    $stdin = fopen('php://stdin', 'r');
    $input = fgets($stdin);

    // Send the message to the server
    if (!socket_sendto($sock, $input, strlen($input), 0, $server, $port)) {
        $errorCode = socket_last_error();
        $errorMsg = socket_strerror($errorCode);

        die ("Couldn't send data: [$errorCode] $errorMsg \n");
    }

    // now receive reply from server and print it
    if (socket_recvfrom($sock, $reply, 2045, MSG_WAITALL) === FALSE) {
        $errorCode = socket_last_error();
        $errorMsg = socket_strerror($errorCode);

        die ("Couldn't not receive data: [$errorCode] $errorMsg \n");
    }

    echo "reply: $reply \n";
}