<?php
/**
 * @version: 0.0.1
 * @author: Jozell M. Rili
 * @description: PHP CRUD functions for dynamic procedural mySQL queries;
 */

/**
 * @param object $con
 * @param string $table
 * @param string $where
 * @param string $order
 * @param int $limit
 * @return array|string $arr|$sqlError
 */
function getData($con, $table, $where = '', $order = 'id DESC', $limit = 0)
{

    $select = "SELECT * FROM $table ORDER BY $order";

    if ($where) $select = "SELECT * FROM $table WHERE $where ORDER BY $order";
    if ($limit > 0) $select .= " limit $limit";

    $arr = array();
    if ($result = mysqli_query($con, $select)) {

        /* fetch associative array */
        while ($row = mysqli_fetch_assoc($result)) {
            $arr[] = $row;
        }

        /* free result set */
        mysqli_free_result($result);
    } else {
        $sqlError = "Error description: " . mysqli_error($con);
        return $sqlError;
    }

    return $arr;
}

/**
 * @param object $con
 * @param string $table
 * @param string $where
 * @param string $column
 * @return array|string $arr|$sqlError
 */
function getDistinctData($con, $table, $where = '', $column = '')
{

    $select = "SELECT DISTINCT $column FROM $table";

    if ($where) $select = "SELECT DISTINCT $column FROM $table WHERE $where";

    $arr = array();
    if ($result = mysqli_query($con, $select)) {

        /* fetch associative array */
        while ($row = mysqli_fetch_assoc($result)) {
            $arr[] = $row;
        }

        /* free result set */
        mysqli_free_result($result);
    } else {
        $sqlError = "Error description: " . mysqli_error($con);
        return $sqlError;
    }

    return $arr;
}


/**
 * @param mysqli object $con
 * @param string $table
 * @param array $keyValuePair
 * @return int|string $sqlError|$lastInsertedId
 */
function createData($con, $table, $keyValuePair)
{
    $columns = [];
    $values = [];

    foreach ($keyValuePair as $key => $value) {
        $columns[] = $key;
        $values[] = $value === NULL ? "NULL" : "'$value'";
    }

    $column = implode(",", $columns);
    $value = implode(",", $values);

    $insert = "INSERT INTO $table ($column) VALUES ($value)";
    $execute = mysqli_query($con, $insert);

    if (!$execute) {
        $sqlError = "Error description: " . mysqli_error($con);
        return $sqlError;
    }

    $lastInsertedId = mysqli_insert_id($con);
    return $lastInsertedId;
}


/**
 * function to update data on the table
 * @param mysqli object $con
 * @param string $table
 * @param array $keyValuePair
 * @param string $where
 * @return bool|string
 */
function updateData($con, $table, $keyValuePair, $where)
{
    $cols = array();

    foreach ($keyValuePair as $key => $val) {
        $cols[] = $val == NULL ? "$key = NULL" : "$key = '$val'";
    }
    $update = "UPDATE $table SET " . implode(', ', $cols) . " WHERE $where";

    $execute = mysqli_query($con, $update);

    if (!$execute) {
        $sqlError = "Error description: " . mysqli_error($con);
        return $sqlError;
    }
    return true;
}


/**
 * function to delete data from the table
 * @param mysqli object $con
 * @param string $table
 * @param string $where
 * @return bool|string
 */
function deleteData($con, $table, $where = '')
{
    $query = "DELETE FROM $table WHERE $where";

    $execute = mysqli_query($con, $query);
    if (!$execute) {
        $sqlError = "Error description: " . mysqli_error($con);
        return $sqlError;
    }

    return true;
}

/** function for custom query
 * @param mysqli object $con
 * @param string $query
 * @return array|string $arr|$sqlError
 */
function customQuery($con, $query)
{
    $arr = array();
    if ($result = mysqli_query($con, $query)) {

        /* fetch associative array */
        while ($row = mysqli_fetch_assoc($result)) {
            $arr[] = $row;
        }

        /* free result set */
        mysqli_free_result($result);
    } else {
        $sqlError = "Error description: " . mysqli_error($con);
        return $sqlError;
    }

    return $arr;
}


