document.querySelector('.hangout-contact-form form').addEventListener('submit', function(e) {
    e.preventDefault();
    const email = document.querySelector('#hangout-input-email').value;
    const message = document.querySelector('#txtmessage').value;
    const apiUrl = 'https://api.comitatensian.com/api/contact-us?site=clairemontferrond';
    const xhr = new XMLHttpRequest();
    xhr.open('POST', apiUrl);
    xhr.setRequestHeader('Content-type', 'application/json');
    xhr.onload = function() {
        let response;
        try {
            response = JSON.parse(xhr.responseText);
        } catch (e) {
            console.error('Error parsing JSON response:', e);
            response = { status: 'An error occurred while processing your request.' };
        }
        const messageDiv = document.querySelector('#message');
        const statusMessage = 'Your message has been successfully sent!';
        messageDiv.innerHTML = '<h4>' + statusMessage + '</h4>';
        messageDiv.classList.add('text-success');
        document.querySelector('#hangout-input-email').value = "";
        document.querySelector('#txtmessage').value = "";
        setTimeout(function(){
            messageDiv.innerHTML = "";
            messageDiv.classList.remove('text-success');
        }, 5000);
    };
    const data = JSON.stringify({
        email: email,
        message: message
    });
    xhr.send(data);
});