<?php
if (!defined('DEVELOPEMENT')) define('DEVELOPMENT', 'cf.local');
if (!defined('PRODUCTION')) define('PRODUCTION', 'clairemontferrond.com');

switch ($_SERVER['SERVER_NAME']) {
    case DEVELOPMENT:
        $baseUrl = DEVELOPMENT;
        $comitatus = DEVELOPMENT . '/comitatus';
        break;
    default:
        $baseUrl = PRODUCTION;
        $comitatus = 'comitatus.' . PRODUCTION;
        break;
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <title>Clairemont Ferrond - Home</title>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="Description" content="A Creative Technolgy Solution Company Who Delivers.">
    <meta name="Keywords" content="Clairemont Ferrond Technologies System Web Application">
    <meta name="author" content="Clairemont Ferrond">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
    <link rel="icon" href="img/logo_favicon.png" type="image/ico">

    <link rel="stylesheet" href="css/style.css">
    <!-- Main Style.css Stylesheet -->
    <link rel="stylesheet" href="css/responsive.css">
    <!-- Resposive.css Stylesheet -->
</head>

<body>

    <!-- Hangout Body Start -->
    <!-- <div id="preloader"></div> -->

    <!-- Hangout Main Menu -->
    <header class="hangout-main-menu-area" id="hangout-menus">
        <div class="container">
            <div class="row">
                <div class="col-md-3 col-sm-3 col-xs-6">
                    <div class="hangout-logo">
                        <a href="#hangout-home">
                            <img src="img/cfst_logo_white.png" height="800px" width="800px" alt="Hangout Logo">
                        </a>
                    </div> <!-- .hangout-logo END -->
                </div>

                <div class="col-md-9 col-sm-9 col-xs-6">
                    <div class="hangout-menu-and-serach clear-both">
                        <span id="hangout-main-menu-icon">
                            <div class="la-ball-elastic-dots la-2x item-generate" style="color:#fa326f">
                                <div></div>
                                <div></div>
                                <div></div>
                            </div>
                        </span>
                        <nav id="hangout-menu" class="hangout-menu">
                            <ul>
                                <li><a href="#hangout-home">Home</a></li>
                                <li><a href="#hangout-feature">Feature</a></li>
                                <li><a href="#hangout-services">Services</a></li>
                                <li><a href="#hangout-products">Products</a></li>
                                <li><a href="#hangout-team">Team</a></li>
                                <li><a href="#hangout-faq">Contact Us</a></li>
                                <!-- <li><a href="//<?php echo $comitatus; ?>" target="_blank" id="toComitatus">Comitatus</a> -->
                                </li>
                            </ul>
                        </nav> <!-- .hangout-menu END -->
                    </div> <!-- .hangout-menu-and-serach END -->
                </div>
            </div>
        </div>
    </header> <!-- .hangout-main-menu END -->

    <!-- Hangout Welcome Section -->
    <section class="hangout-welcome-section" style="background-image: url(img/welcome-bg.jpg);" id="hangout-home">
        <div class="hangout-position-rel hidden-xs">
            <div id="hangout_animation">
                <div class="layer" data-depth="0.20"><img src="img/home-gradiant-bg-1.png" alt="Home Gradient Background 1">
                </div>
                <div class="layer hangout_layer_z" data-depth="0.20"><img src="img/home-gradiant-bg-2.png" alt="Home Gradient Background 2"></div>
            </div>
        </div>
        <div class="hangout-welcome-container">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-sm-8 col-xs-12">
                        <div class="hangout-welcome-tbl">
                            <div class="hangout-welcome-tbl-c">
                                <div class="hangout-welcome-content">
                                    <h1>A creative <br><span>Technology Solutions <br> Company</span> who delivers.</h1>

                                    <!--								<div class="hangout-download-store-btn-group">-->
                                    <!--									<a href="#" class="hangout-btn play-store-btn">Learn More</a>-->
                                    <!-- <a href="#" class="hangout-btn app-store-btn">Visit Now</a> -->
                                    <!--								</div>-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-4 hidden-xs text-right">
                        <div class="hangout-welcome-screenshort">
                            <div class="hangout-welcome-tbl">
                                <div class="hangout-welcome-tbl-c">
                                    <figure class="hangout-welcome-section-screen-short">
                                        <img src="img/home1.png" alt="" class="wow fadeIn" data-wow-delay=".4s">
                                    </figure>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Hangout About -->
        <div class="hangout-about-section" id="hangout-about">
            <div class="container">
                <div class="row">
                    <div class="col-md-4 col-sm-4 col-xs-12">
                        <div class="hangout-single-about wow fadeIn" data-wow-delay="400ms">
                            <span class="icon-layers"></span>
                            <h3>Powerful Feature</h3>
                            <p>Robust collaboration tools to empower your business with enhanced security. </p>
                        </div> <!-- .hangout-single-about END -->
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-12">
                        <div class="hangout-single-about wow fadeIn" data-wow-delay="600ms">
                            <span class="icon-tools"></span>
                            <h3>Awesome Design</h3>
                            <p>A unique and distinctive responsive system designs that is user friendly. </p>
                        </div> <!-- .hangout-single-about END -->
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-12">
                        <div class="hangout-single-about wow fadeIn" data-wow-delay="800ms">
                            <span class="icon-tools-2"></span>
                            <h3>Support</h3>
                            <p>An integral component of our dedication and high-level service commitment to our
                                customers. </p>
                        </div> <!-- .hangout-single-about END -->
                    </div>
                </div>
            </div>
        </div> <!-- .hangout-about-section END -->
    </section> <!-- .hangout-welcome-section END -->


    <!-- Hangout feature -->
    <section class="hangout-feature-section section-padding" id="hangout-feature">
        <div class="container">
            <div class="hangout-section-heading">
                <h2>Features</h2>
            </div> <!-- .hangout-section-heading END -->
            <div class="row content-margin-top">
                <div class="col-md-6 col-sm-12 col-xs-12 features-mobile">
                    <div class="hangout-feature-img text-center" itemscope itemtype="">
                        <figure itemprop="associatedMedia" itemscope itemtype="">
                            <img src="img/feature1.png" alt="Hangout Feature Image">

                            <span class="hangout-feature-ico icon-1x" data-bottom="transform:translateX(-103px)" data-top="transform:translateX(-63px);">
                                <img src="img/icon/Icon-1.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-2x" data-bottom="transform:translateX(-171px)" data-top="transform:translateX(-131px);">
                                <img src="img/icon/ICON-2.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-3x" data-bottom="transform:translateX(-153px)" data-top="transform:translateX(-113px);">
                                <img src="img/icon/12.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-4x" data-bottom="transform:translateX(-176px)" data-top="transform:translateX(-136px);">
                                <img src="img/icon/ICON-5.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-5x" data-bottom="transform:translateX(-97px)" data-top="transform:translateX(-55px);">
                                <img src="img/icon/ICON-7.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-6x" data-bottom="transform:translateY(-130px)" data-top="transform:translateY(-90px);">
                                <img src="img/icon/15.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-7x" data-bottom="transform:translateY(-134px)" data-top="transform:translateY(-94px);">
                                <img src="img/icon/icon-3.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-8x" data-bottom="transform:translateY(-160px)" data-top="transform:translateY(-120px);">
                                <img src="img/icon/ICON--9.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-9x" data-bottom="transform:translateX(-110px)" data-top="transform:translateX(-70px);">
                                <img src="img/icon/ICON-11.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-10x" data-bottom="transform:translateY(26px)" data-top="transform:translateY(26px);">
                                <img src="img/icon/13.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-11x" data-bottom="transform:translateX(74px)" data-top="transform:translateX(34px);">
                                <img src="img/icon/ICon4.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <!-- <span class="hangout-feature-ico icon-12x" data-bottom="transform:translateX(160px)" data-top="transform:translateX(60.059px);">
                                <img src="img/icon/ICON-10.png" alt="Small Icon">
                            </span> -->
                            <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-13x" data-bottom="transform:translateX(150px)" data-top="transform:translateX(110px);">
                                <img src="img/icon/ICON-6.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-14x" data-bottom="transform:translateX(80px)" data-top="transform:translateX(40px);">
                                <img src="img/icon/15.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-15x" data-bottom="transform:translateX(120px)" data-top="transform:translateX(80px);">
                                <img src="img/icon/13.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->

                            <span class="hangout-feature-ico icon-16x" data-bottom="transform:translateX(-140px)" data-top="transform:translateX(-100px);">
                                <img src="img/icon/18.png" alt="Small Icon">
                            </span> <!-- .hangout-feature-ico END -->
                        </figure>
                    </div> <!-- .hangout-feature-img END -->
                </div>

                <div class="col-md-6 col-sm-12 col-xs-12 f-f-box">
                    <div class="hangout-feature-container clear-both">
                        <div class="hangout-single-feature">
                            <div class="hangout-feature-content wow fadeIn s-f-box" data-wow-delay="200ms">
                                <i class="zmdi zmdi-devices zmdi-hc-fw"></i>
                                <h3>Adaptive Design</h3>
                                <p>Consistent user experience designed to support multitude of devices, ensuring accessibility and inter-usability for all solutions.</p>
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                        <div class="hangout-single-feature">
                            <div class="hangout-feature-content wow fadeIn s-f-box" data-wow-delay="400ms">
                                <i class="zmdi zmdi-shield-security zmdi-hc-fw"></i>
                                <h3>Risk-Mitigation Framework</h3>
                                <p>Comprehensive approach to privacy, security and compliance, incorporating a holistic strategy on all aspects of risk mitigation.</p>
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                        <div class="hangout-single-feature">
                            <div class="hangout-feature-content wow fadeIn s-f-box" data-wow-delay="600ms">
                                <i class="zmdi zmdi-aspect-ratio zmdi-hc-fw"></i>
                                <h3>Improved Scalability</h3>
                                <p>Seamless and efficient solutions that supports influx of process while maintaining optimal performance.</p>
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                        <div class="hangout-single-feature">
                            <div class="hangout-feature-content wow fadeIn s-f-box" data-wow-delay="800ms">
                                <i class="zmdi zmdi-chart zmdi-hc-fw"></i>
                                <h3>Personal Touch</h3>
                                <p>Developing strategies and solutions together expanding your business capabilities achieving optimum potential growth.</p>
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                    </div> <!-- .hangout-feature-container END -->
                </div>
            </div>
        </div>
    </section>

    <!-- Hangout services -->
    <section class="hangout-feature-section section-padding" id="hangout-services">
        <div class="container">
            <div class="hangout-section-heading">
                <h2>Services</h2>
            </div> <!-- .hangout-section-heading END -->
            <div class="row content-margin-top">
                <div class="col-md-12 col-sm-12 col-xs-12 f-f-box">
                    <div class="text-center">
                        <div class="col-md-4 pb-1">
                            <div class="hangout-feature-content wow fadeIn s-f-box-services" data-wow-delay="200ms">
                                <i class="zmdi zmdi-device-hub zmdi-hc-fw"></i>
                                <h3>Technical Outsource</h3>
                                <p>Maximize efficiency and productivity with our exceptional cutting-edge technologies and solutions expert that facilitate cost cutting and let businesses focus on their core competencies.  These include solution development, network design and management or migrations we are in position to augment workforce of all levels.</p>
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                        <div class="col-md-4 pb-1">
                            <div class="hangout-feature-content wow fadeIn s-f-box-services" data-wow-delay="400ms">
                                <i class="zmdi zmdi-badge-check zmdi-hc-fw"></i>
                                <h3>Customized Solutions</h3>
                                <p>With the latest frameworks and development methodologies together with our experienced solutions architects we develop high-quality, scalable solutions that deliver value to our clients.</p>    
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                        <div class="col-md-4 pb-1">
                            <div class="hangout-feature-content wow fadeIn s-f-box-services" data-wow-delay="600ms">
                                <i class="zmdi zmdi-laptop zmdi-hc-fw"></i>
                                <h3>Turnkey Platforms</h3>
                                <p>Provides a comprehensive, ready to use package that is scalable, flexible and customizable to meet the unique needs of each business, saving time and resources, reducing costs and improving overall user experience for their customers.</p>    
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                        <div class="col-md-4 pb-1 col-md-offset-2">
                            <div class="hangout-feature-content wow fadeIn s-f-box-services" data-wow-delay="800ms">
                                <i class="zmdi zmdi-devices zmdi-hc-fw"></i>
                                <h3>Innovative Devices</h3>
                                <p>Evolutionary equipment that operates effectively and efficiently with our turnkey platforms.  Developed for enhanced performance, improved user experience and greater performance.</p>    
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                        <div class="col-md-4 pb-1">
                            <div class="hangout-feature-content wow fadeIn s-f-box-services" data-wow-delay="800ms">
                                <i class="zmdi zmdi-chart zmdi-hc-fw"></i>
                                <h3>Skills Coaching </h3>
                                <p>Personalized training program tailored to help individuals improve their technology-related competencies.  Crafted to focus on practical, hands-on learning to assist in mastering the latest IT tools and techniques empowering self-reliance and enhancing capabilities</p>    
                            </div> <!-- .hangout-feature-content END -->
                        </div> <!-- .hangout-single-feature END -->
                    </div> <!-- .hangout-feature-container END -->
                </div>
            </div>
        </div>
    </section>

    <!-- Apps Crfat Why Choose Us Section -->
    <section class="hangout-why-chose-us-section section-padding pb-3" id="hangout-chose-us" data-0="background-position:0px 10000px;" data-100000="background-position:0px -50000px;">
        <div class="container">
            <div class="hangout-section-heading">
                <h2>Why choose us</h2>
            </div> <!-- .hangout-section-heading END -->
            <div class="row content-margin-top">
                <div class="col-md-6 col-sm-6 col-xs-12">
                    <div class="hangout-why-choose-us-container clear-both">
                        <div class="hangout-why-choose-us-container-inner clear-both">
                            <div class="hangout-why-chose-single clear-both">
                                <div class="hangout-why-chose-ico">
                                    <span class="icon-search hangout-round">
                                        <span class="hangout-dash-border"></span>
                                    </span>
                                </div> <!-- .hangout-why-chose-ico END -->

                                <div class="hangout-why-chose-txt">
                                    <h3>Effective Navigation</h3>
                                    <p>Well planned information architecture that has a well-formatted content that is
                                        accessible to all users.</p>
                                </div> <!-- .hangout-why-chose-txt END -->
                            </div> <!-- .hangout-why-chose-single END -->
                            <div class="hangout-why-chose-single clear-both">
                                <div class="hangout-why-chose-ico">
                                    <span class="icon-browser hangout-round">
                                        <span class="hangout-dash-border"></span>
                                    </span>
                                </div> <!-- .hangout-why-chose-ico END -->

                                <div class="hangout-why-chose-txt">
                                    <h3>Awesome UI & UX</h3>
                                    <p>We create digital experiences for your brand communication reflecting your vision
                                        your customers.</p>
                                </div> <!-- .hangout-why-chose-txt END -->
                            </div> <!-- .hangout-why-chose-single END -->
                            <div class="hangout-why-chose-single clear-both">
                                <div class="hangout-why-chose-ico">
                                    <span class="icon-global hangout-round"></span>
                                </div> <!-- .hangout-why-chose-ico END -->

                                <div class="hangout-why-chose-txt">
                                    <h3>Our approach</h3>
                                    <p>We develop using industry standard frameworks tailored for sustainability,
                                        adaptibility and scalability.</p>
                                </div> <!-- .hangout-why-chose-txt END -->
                            </div> <!-- .hangout-why-chose-single END -->
                        </div> <!-- .hangout-why-choose-us-container-inner END -->
                    </div> <!-- .hangout-why-choose-us-container END -->
                </div>

                <div class="col-md-6 col-sm-6 col-xs-12">
                    <!-- <figure class="hangout-why-chose-img" itemscope itemtype="http://schema.org/ImageGallery">
                        <img src="img/choose-us-screenshort-1.png" class="wow fadeInRight" data-wow-delay=".8s" alt="Hangout Why Chose Image Screenshort"> -->
                    <img src="img/whychooseus.png" class="wow fadeInRight" data-wow-delay=".4s" alt="Hangout Why Chose Image Screenshort">
                    <!-- /figure> -->
                    <!-- .hangout-why-chose-img END -->
                </div>
            </div>
        </div>
    </section> <!-- .hangout-why-chose-us-section END -->

    <div class="hangout-now-available-section" id="hangout-available" style="background-image: url(img/now-available-on-round-bg.png);">
        <div class="container">
            <div class="row">
                <div class="col-md-12 mt-sm pb-1">
                    <div class="hangout-tbl">
                        <div class="hangout-tbl-c">
                            <div class="hangout-now-available-content wow fadeIn">
                                <h3>Who We Are</h3>
                                <p>Clairemont Ferrond is a premium technology solutions development company that focuses on
                                    innovation, reliability and cost effectiveness. Our talented team of analysts, designers
                                    and developers has created a multidimensional space where our identity is showcased and
                                    our clients find interactivity. We understand what it takes to be leveraged so we
                                    undertake intensive research and consultation to be able to develop system applications
                                    with multiple verticals. We combine our expertise and technology to deliver an IT
                                    solution that does more obtaining an overall improved presence.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- products section -->
    <section class="section-padding hangout-product-section" id="hangout-products">
        <div class="container">
            <div class="hangout-section-heading">
                <h2>Our Products</h2>
            </div>
            <div class="row text-center products-row">
                <!-- Product 8 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/8.png" alt="Comitatus">
                        <h5 class="product-title mt-3">Comitatus</h5>
                        <p class="product-desc">School management system for streamlined academic operations.</p>
                    </div>
                </div>
                <!-- Product 9 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/9.png" alt="Salus">
                        <h5 class="product-title mt-3">Salus</h5>
                        <p class="product-desc">Comprehensive clinic management solution for efficient healthcare operations.</p>
                    </div>
                </div>
                <!-- Product 10 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/10.png" alt="Smart Scan Detector">
                        <h5 class="product-title mt-3">Smart Scan Detector</h5>
                        <p class="product-desc">Advanced walk-through detector designed for precise security screening.</p>
                    </div>
                </div>
                <!-- Product 1 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/1.png" alt="Tripod Turnstiles">
                        <h5 class="product-title mt-3">Tripod Turnstiles</h5>
                        <p class="product-desc">Compact access control system ensuring secure and reliable entry points.</p>
                    </div>
                </div>
                <!-- Product 2 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/2.png" alt="Swing Turnstiles">
                        <h5 class="product-title mt-3">Swing Turnstiles</h5>
                        <p class="product-desc">Elegant turnstile solution providing smooth and controlled passageways.</p>
                    </div>
                </div>
                <!-- Product 3 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/3.png" alt="Digital RFID Locker">
                        <h5 class="product-title mt-3">Digital RFID Locker</h5>
                        <p class="product-desc">Secure storage solution with smart RFID-enabled access control system.</p>
                    </div>
                </div>
                <!-- Product 4 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/4.png" alt="Smart Vendo Machine">
                        <h5 class="product-title mt-3 text-nowrap">Smart Vendo Machine</h5>
                        <p class="product-desc">Automated vending solution for convenient and cashless transactions.</p>
                    </div>
                </div>
                <!-- Product 5 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/5.png" alt="RFID Scanner">
                        <h5 class="product-title mt-3">RFID Scanner</h5>
                        <p class="product-desc">Fast and accurate RFID scanner designed for access and tracking.</p>
                    </div>
                </div>
                <!-- Product 6 -->
                <div class="col-sm-6 col-md-3 col-md-offset-3">
                    <div class="product-card">
                        <img src="products/6.png" alt="Blank RFID Card">
                        <h5 class="product-title mt-3">Blank RFID Card</h5>
                        <p class="product-desc">Programmable RFID cards compatible with a wide range of systems.</p>
                    </div>
                </div>
                <!-- Product 7 -->
                <div class="col-sm-6 col-md-3">
                    <div class="product-card">
                        <img src="products/7.png" alt="PVC Card Printer">
                        <h5 class="product-title mt-3">PVC Card Printer</h5>
                        <p class="product-desc">High-quality printing solution for durable and customizable RFID cards.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- team section -->
    <section class="hangout-team-section section-padding" id="hangout-team">
        <div class="container">
            <div class="hangout-section-heading">
                <h2>Our Team</h2>
            </div> <!-- .hangout-section-heading END -->
            <div class="row content-margin-top">
                <div class="col-md-6 col-sm-6 col-xs-12">
                    <div class="hangout-accordion wow fadeIn" data-wow-delay="400ms">
                        <div class="panel-group" id="accordion">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4 class="panel-title click">
                                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse1" class="">
                                            Belief</a>
                                    </h4>
                                </div>
                                <div id="collapse1" class="panel-collapse collapse in">
                                    <div class="panel-body">We want to create an IT solution that is easy to find,
                                        stylish, responsive and
                                        affordable without sacrificing quality and speed.
                                    </div>
                                </div>
                            </div>
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse2" class="collapsed">
                                            Goal</a>
                                    </h4>
                                </div>
                                <div id="collapse2" class="panel-collapse collapse">
                                    <div class="panel-body">We place a strong, competitive focus on privacy, security and
                                        compliance and with its integration together with our business model we deliver
                                        best-in class solutions and services with quick, easy and hassle-free experience.
                                    </div>
                                </div>
                            </div>
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse3" class="collapsed">
                                            Design Group</a>
                                    </h4>
                                </div>
                                <div id="collapse3" class="panel-collapse collapse">
                                    <div class="panel-body">With our award winning designers, we determine the different
                                        important factors when designing interfaces. With this, we work closely with our
                                        consultants and the business to ensure the requirements are realized to bring our
                                        ideas into a stunning life.
                                    </div>
                                </div>
                            </div>
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse4" class="collapsed">
                                            Development Group</a>
                                    </h4>
                                </div>
                                <div id="collapse4" class="panel-collapse collapse">
                                    <div class="panel-body">As a leading IT solution's company. We have an
                                        extensive experience in creating high performance, feature-packed web application
                                        supported by different platforms. We create applications that not only meet the
                                        needs of the industry but surpasses its requirement to enhance user experience.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> <!-- .hangout-accordion END -->
                </div>

                <div class="col-md-6 col-sm-6 col-xs-12">
                    <img src="img/CFITS.png" class="wow fadeInRight" data-wow-delay=".4s" alt="team">
                </div>
            </div>
        </div>
    </section>

    <!-- Hangout FAQ Section -->
    <section class="hangout-faq-section section-padding" id="hangout-faq">
        <div class="container">
            <div class="hangout-section-heading">
                <h2>Got Questions?</h2>
            </div> <!-- .hangout-section-heading END -->
            <div class="row content-margin-top">
                <div class="col-md-8 col-md-offset-2 col-sm-6 col-xs-12">
                    <div class="hangout-contact-form-content wow fadeIn" data-wow-delay="800ms">
                        <div class="hangout-contact-form-content-inner">
                            <h2>Any other question? You can <span>contact us.</span></h2>
                            <div id="message" class="pb-1 text-success"><h4></h4></div>
                            <div class="hangout-contact-form">
                                <form id="contact-form" action="sendmail.php" method="POST">
                                    <input type="email" id="hangout-input-email" name="email" placeholder="youremail@domain.com">
                                    <textarea name="txtmessage" id="txtmessage" cols="30" rows="10" placeholder="Your Message Here.."></textarea>
                                    <div class="hangout-submit-btn-ar">
                                        <input type="submit" name="Send Message" value="Send Message" id="hangout-input-send">
                                    </div>
                                </form>
                            </div> <!-- .hangout-contact-form END -->
                        </div> <!-- .hangout-contact-form-content-inner END -->
                    </div> <!-- .hangout-contact-form-content END -->
                </div>
            </div>
        </div>
    </section> <!-- .hangout-faq-section END -->


    <!-- Hangout Footer Section -->
    <footer class="hangout-footer-section" id="hangout-footer">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="hangout-footer-logo-and-social">
                        <figure class="hangout-footer-logo text-center">
                            <a href="#">
                                <img src="img/cfst_logo_white.png" height="500px" width="500px" alt="Hangout Footer Logo" class="wow fadeInUp" data-wow-delay=".2s">
                            </a>
                        </figure> <!-- .hangout-footer-logo END -->
                        <div class="hangout-social-link wow fadeInUp" data-wow-delay=".4s">
                            <ul>
                                <li><a href="#"><i class="zmdi zmdi-facebook zmdi-hc-fw"></i></a></li>
                                <li><a href="#"><i class="zmdi zmdi-google-plus zmdi-hc-fw"></i></a></li>
                                <li><a href="#"><i class="zmdi zmdi-twitter zmdi-hc-fw"></i></a></li>
                            </ul>
                        </div> <!-- .hangout-social-link END -->
                    </div> <!-- .hangout-footer-logo-and-social END -->
                    <div class="hangout-footer-menu-and-copyright-txt clear-both">
                        <div class="hangout-copyright-txt wow fadeInUp" data-wow-delay=".6s">
                            <p style="width:500px">&copy; <?php echo date("Y"); ?> Clairemont Ferrond. All Right Reserved</p>
                        </div> <!-- .hangout-copyright-txt END -->
                        <nav class="hangout-footer-menu wow fadeInUp" data-wow-delay=".8s">
                            <ul>
                                <li><a href="#hangout-home">Home</a></li>
                                <li><a href="#hangout-feature">Feature</a></li>
                                <li><a href="#hangout-services">Services</a></li>
                                <li><a href="#hangout-products">Products</a></li>
                                <li><a href="#hangout-team">Team</a></li>
                                <li><a href="#hangout-faq">Contact Us</a></li>
                                <!-- <li><a href="//<?php echo $comitatus; ?>" target="_blank">Comitatus</a></li> -->
                                <!-- <li><a href="#hangout-pricing">pricing</a></li> -->
                            </ul>
                        </nav> <!-- .hangout-footer-menu END -->
                    </div> <!-- .hangout-footer-menu-and-copyright-txt END -->
                </div>
            </div>
        </div>
    </footer> <!-- .hangout-footer-section END -->

    <!-- js File Start -->
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-137271695-1"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'UA-137271695-1');
    </script>
    <script type="text/javascript" src="js/jquery-3.1.1.min.js"></script>
    <!-- jquery-3.1.1.min.js -->
    <script type="text/javascript" src="js/jquery.ajaxchimp.min.js"></script>
    <!--jquery.ajaxchimp.min.js  -->
    <script type="text/javascript" src="js/jquery.easing.1.3.js"></script>
    <!--jquery.easing.1.3.js  -->
    <script type="text/javascript" src="js/bootstrap.min.js"></script>
    <!-- bootstrap.min.js -->
    <script src="js/owl.carousel.min.js"></script>
    <!-- owl.carousel.min.js -->
    <script src="js/isotope.pkgd.min.js"></script>
    <!-- isotope.pkgd.min.js -->
    <script src="js/jquery.magnific-popup.min.js"></script>
    <!-- jquery.magnific-popup.min.js -->
    <script src="js/skrollr.min.js"></script>
    <!-- skrollr.min.js -->
    <script src="js/utils.js"></script>
    <!-- utils.js -->
    <script src="js/jquery.parallax.js"></script>
    <!-- jquery.parallax.js -->
    <script src="js/wow.js"></script>
    <!-- wow.js -->
    <script src="js/jquery.tubular.1.0.js"></script>
    <!-- jquery.tubular.1.0.js -->
    <script src="js/particles.js"></script>
    <!-- jquery.particles.js -->

    <script src="js/main.js"></script>
    <script src="js/contact.js"></script>
    <!-- main.js -->
</body>

</html>