/*!
 * JMR Field Validator
 *
 * Copyright 2018, Jozell M. Rili
 *
 *jmr-validator.js is an open source script that makes it easy to validate
 * form fields on the client side
 */

/**
 *
 * @param param string|int parameter to validate
 * @param min int
 * @param max int
 * @returns {{}}
 */
var jmrValidator = function(param, min, max) {
    var jmrValidator = {};
    var len = param.length;

    //check if param is empty
    jmrValidator.isEmpty = function() {
        return len == 0;
    };

    //check if value is a url and is valid
    jmrValidator.isValidUrl = function() {
        var elm;

        if(len == 0) return false;
        if(!elm) {
            elm = document.createElement('input');
            elm.setAttribute('type', 'url');
        }
        elm.value = param;
        return elm.validity.valid;
    };

    //check if string is too long
    jmrValidator.stringTooLong = function () {
        return len > max;
    };

    //check if string is too short
    jmrValidator.stringTooShort = function () {
        return len < min;
    };

    //check if param is a number
    jmrValidator.isNumber = function () {
        return $.isNumeric(param);
    };

    jmrValidator.isEmail = function () {
        var re = /^[a-z][a-zA-Z0-9_.]*(\.[a-zA-Z][a-zA-Z0-9_.]*)?@[a-z][a-zA-Z-0-9]*\.[a-z]+(\.[a-z]+)?$/;
        return re.test(param);
    };

    return jmrValidator;
};
