( function($) {
	var skinSelector = $('#control-sidebar-theme-demo-options-tab ul li');

	function onSkinSelect(e) {
		var skin = $(this).find('a').eq(0).attr('data-skin');
		var id = $('.userId').val();
		console.log(skin)

		$.ajax({
			type: "POST",
			url: 'functions/requestManager.php',
			data: {skin: skin, id: id},
			error: function(jqXHR, textStatus, errorThrown) {
				console.log(textStatus, errorThrown);
			},
			success: function (response) {
				var resData = $.parseJSON(response);
				console.log(resData);
			},
		});
	}
	
	function init() {
		skinSelector.addClass('skin-selector');
		skinSelector.on('click', onSkinSelect);
		$('.datepicker').datepicker({
			autoclose: true
		});
		$('.daterangepicker').daterangepicker();
		$(".timepicker").timepicker({
			showInputs: false
		});
		$(".select2").select2();
		$('#daterange-btn').daterangepicker(
			{
				ranges: {
					'Today': [moment(), moment()],
					'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
					'Last 7 Days': [moment().subtract(6, 'days'), moment()],
					'Last 30 Days': [moment().subtract(29, 'days'), moment()],
					'This Month': [moment().startOf('month'), moment().endOf('month')],
					'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
				},
				startDate: moment().subtract(29, 'days'),
				endDate: moment()
			},
			function (start, end) {
				$('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
				$('#dateValue').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
				$('#dateValue').trigger('change');
			}
		);

        $('[data-toggle="tooltip"]').tooltip();
    }
	$(document).ready(init);

}(jQuery));