<?php
define('SITE_NAME', 'medicus_cms');

register_shutdown_function(function() {
    $errors = error_get_last();
    if($errors) {
        echo '<h1>Under Maintenance!</h1>';
        echo '<script>console.log('.json_encode($errors).')</script>';
    }
});

// Decline static file requests back to the PHP built-in webserver
if (php_sapi_name() === 'cli-server') {
    $path = realpath(__DIR__ . parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    if (__FILE__ !== $path && is_file($path)) {
        return false;
    }
    unset($path);
}

// Environment initial setup
$hostName = preg_replace('/[0-9]+$/', '', strtolower(gethostname()));
switch($hostName) {
    // Local
    default:
        define('ENV', 'local');
        define('PUBLIC_PATH', __DIR__);
        define('LIBS_PATH', __DIR__.'/../../libraries');
        define('TEMP_DIR', sys_get_temp_dir());
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        chdir(__DIR__);
        require LIBS_PATH.'/v2.5.3/vendor/autoload.php';
        break;

    // Local staging
    case 'ubuntu':
        define('ENV', 'local-staging');
        define('PUBLIC_PATH', __DIR__);
        define('LIBS_PATH', __DIR__.'/../../libraries');
        define('TEMP_DIR', '/tmp/');
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        chdir(__DIR__);
        require LIBS_PATH.'/v2/vendor/autoload.php';
        break;

    // Remote staging
    case 'mkt-s-adm':
        define('ENV', 'remote-staging');
        define('PUBLIC_PATH', __DIR__);
        define('LIBS_PATH', '/opt/data/www/gllibs');
        define('TEMP_DIR', '/var/www/php_tmp/');
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        chdir(__DIR__);
        require LIBS_PATH.'/v2/vendor/autoload.php';
        break;

    // Production
    case 'mkt-p-adm':
        define('ENV', 'prod');
        define('PUBLIC_PATH', __DIR__);
        define('LIBS_PATH', '/opt/data/www/gllibs');
        define('TEMP_DIR', '/var/www/php_tmp/');
        chdir(__DIR__);
        require LIBS_PATH.'/v2/vendor/autoload.php';
        break;
}

Zend\Mvc\Application::init(require 'config/application.config.php')->run();

