<?php

namespace Comitatus\Service\Navigation;

use Comitatus\Service\Account\AccountManager;
use Zend\Navigation\Service\AbstractNavigationFactory;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Session\Container;

class MainNavigation extends AbstractNavigationFactory
{
    /** @var  ServiceLocatorInterface */
    protected $serviceLocator;

    protected function getName()
    {
        /** @var AccountManager $accountManager */
        $accountManager = $this->serviceLocator->get(AccountManager::class);

        $sessionContainer = new Container('comitatus');
        $currentUser = $sessionContainer->offsetExists('current_user') ? $sessionContainer->offsetGet('current_user') : [];

        if (count($currentUser)) {

            if (!isset($currentUser['access_permit']) && intval($currentUser['is_admin']) == 1) {
                $access = AccountManager::ACCESS_ADMIN;
            } else $access = $currentUser['access_permit'];

            return $accountManager->getAccessRight($access);
        }

        return $accountManager->getAccessRight(AccountManager::ACCESS_GUEST);
    }

    /**
     * @param ServiceLocatorInterface $container
     * @param null|string|null $name
     * @param null|string|null $requestedName
     * @return mixed
     */
    public function createService(ServiceLocatorInterface $container, $name = null, $requestedName = null)
    {
        $this->serviceLocator = $container;
        return parent::createService($container, $name, $requestedName);
    }
}