<?php

namespace Comitatus\Service\Excel;

use BaseModule\Service\AbstractBaseService;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Zend\Http\Headers;
use Zend\Http\Response;

class GenerateReport extends AbstractBaseService
{

    public function createSpreadsheet($options = [])
    {
        /** @var Spreadsheet $spreadsheet */
        $spreadsheet = new Spreadsheet();

        // metadata(s)
        $spreadsheet->getProperties()
            ->setCreator('Comitatus')
            ->setLastModifiedBy($options['current_user'])
            ->setTitle($options['title'])
            ->setSubject($options['subject'])
            ->setCompany('Clairemont Ferrond Systems & Technologies')
            ->setDescription('Generated report from "Comitatus"');

        if (count($options['data'])) {
            $alphas = range('A', 'Z');
            $row    = 1;
            foreach ($options['data'] as $key => $value) {

                $col = 1;
                foreach ($value as $index => $item) {
                    $spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $item);
                    $col++;
                }
                $row++;
                $col = 1;
            }

            $colCount = count($options['data'][0]);

            //set color on first row
            $spreadsheet->getActiveSheet()
                ->getStyle('A1:' . $alphas[$colCount - 1] . '1')
                ->getFill()
                ->setFillType(Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB('00a65a');

            // auto size columns
            foreach (range('A', $alphas[$colCount - 1]) as $columnID) {
                $spreadsheet->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
            }

            //rename active sheet
            $spreadsheet->getActiveSheet()->setTitle('Page1');
        }

        header('Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheett');
        header('Content-Disposition: attachment; filename="' . $options['file_name'] . '.xlsx"');
        header('Cache-Control: max-age=0');

        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
        exit;
    }
}