<?php

namespace Comitatus\Service\EmailManager;

use BaseModule\Service\AbstractBaseService;
use PHPMailer\PHPMailer\PHPMailer;

class EmailManager extends AbstractBaseService
{
    const EMAIL_TYPE_TEXT = 'text/plain';
    const EMAIL_TYPE_HTML = 'text/html';

    private $phpMailer;

    public function __construct()
    {
        /** @var PHPMailer phpMailer */
        $this->phpMailer = new PHPMailer();
    }

    public function sendEmail($email, $subject, $body, $attachment = [], $type = self::EMAIL_TYPE_HTML)
    {
        try {
            // Server settings
            $this->phpMailer->SMTPDebug = 0;                                          // Enable verbose debug output
            $this->phpMailer->isSMTP();                                               // Set mailer to use SMTP
            $this->phpMailer->Host       = 'host130.hostmonster.com';                 // Specify main and backup SMTP servers
            $this->phpMailer->SMTPAuth   = true;                                      // Enable SMTP authentication
            $this->phpMailer->Username   = 'alert@comitatus.clairemontferrond.tech';  // SMTP username
            $this->phpMailer->Password   = 'L30n1da521!';                             // SMTP password
            $this->phpMailer->SMTPSecure = 'ssl';                                     // Enable TLS encryption, `ssl` also accepted
            $this->phpMailer->Port       = 465;                                       // TCP port to connect to

            // Recipients
            $this->phpMailer->setFrom('alert@comitatus.clairemontferrond.tech', 'Comitatus');
            //            $this->phpMailer->addAddress('alert@comitatus.clairemontferrond.tech');                               // Add a recipient
            $this->phpMailer->addReplyTo('contact@clairemontferrond.com', 'Comitatus Information');
            //            $this->phpMailer->addCC('cc@example.com');
            $this->phpMailer->addBCC($email);

            // Attachments
            if ($attachment) {
                foreach ($attachment as $key => $value) {
                    $this->phpMailer->addAttachment($value);                    // Add attachments
                }
            }

            // Content
            $this->phpMailer->isHTML(true);                                     // Set email format to HTML
            $this->phpMailer->Subject = $subject;
            $this->phpMailer->Body    = $body;
            $this->phpMailer->AltBody = $body;

            $this->phpMailer->send();

            // clear emails
            $this->phpMailer->clearBCCs();
            $this->phpMailer->clearAddresses();
            $this->phpMailer->clearAllRecipients();

            $message = 'Message has been sent';
            $sent    = true;
        } catch (\Exception $e) {
            $message = 'Mailer Error: ' . $this->phpMailer->ErrorInfo;
            $sent    = false;
        }

        return ['sent' => $sent, 'message' => $message];

    }
}