<?php

namespace Comitatus\Service\Canteen;

use BaseModule\Service\AbstractBaseService;
use Comitatus\Service\Database\DatabaseService;
use Zend\Db\Sql\Sql;

class CanteenService extends AbstractBaseService
{
    public function getProductFacilities($id)
    {
        $select = $this->sql->select(DatabaseService::CANTEEN_FAC_TBL);
        $select->columns(['id', 'name']);
        $select->join(['facility_map' => DatabaseService::CANTEEN_FAC_ITEMS_TBL], 'facility_map.facility_id = '. DatabaseService::CANTEEN_FAC_TBL.'.id', ['stock_count'], $select::JOIN_LEFT);
        $select
            ->where
            ->equalTo('facility_map.item_id', $id);
        $select->order([DatabaseService::CANTEEN_FAC_TBL.'.name ASC']);

        $result = $this->sql->prepareStatementForSqlObject($select)->execute();

        $array = [];
        if ($result->count()) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }

        return $array;
    }

    public function setDatabase($adapter)
    {
        $this->sql = new Sql($adapter);
    }
}