<?php

namespace Comitatus\Service\Attendance;

use BaseModule\Service\AbstractBaseService;
use Zend\Db\Sql\Sql;
use Zend\Paginator\Adapter\DbSelect;
use Zend\Paginator\Paginator;

class AttendanceManager extends AbstractBaseService
{
    const ATTENDANCE_TBL  = 'attendance';
    const USER_TABLE      = 'user_accounts';
    const LEVEL_TBL       = 'grade_levels';
    const SECTION_TBL     = 'level_section';
    const GUARDIAN_TBL    = 'user_guardian';
    const DY_SCHEDULE_TBL = 'daily_schedule';

    public function getAllAttendanceRecords($userType = 'a', $where = [], $range = [], $order = [], $paginated = false, $limit = 0, $offset = 0)
    {
        $select = $this->sql->select(['parent' => self::ATTENDANCE_TBL]);
        $select
            ->join(['user' => self::USER_TABLE], 'user.id = parent.user_id', ['first_name', 'last_name', 'generated_id' => 'user_id', 'access_permit'], $select::JOIN_LEFT)
            ->join(['level' => self::LEVEL_TBL], 'level.id = user.level', ['level_name' => 'name'], $select::JOIN_LEFT)
            ->join(['section' => self::SECTION_TBL], 'section.id = user.section', ['section_name' => 'name'], $select::JOIN_LEFT)
            ->join(['guardian' => self::GUARDIAN_TBL], 'guardian.id = parent.user_id', ['guardian_fname' => 'first_name', 'guardian_lname' => 'last_name', 'guardian_card' => 'card_id'], $select::JOIN_LEFT);


        if (count($where) > 0)
            $select->where($where);
        if (count($order) > 0)
            $select->order($order);
        if ($limit != 0)
            $select->limit($limit);
        if ($offset != 0)
            $select->offset($limit);

        if (count($range)) {
            $select
                ->where
                ->greaterThanOrEqualTo('parent.date_created', $range[0])
                ->and
                ->lessThanOrEqualTo('parent.date_created', $range[1]);
        }

        // for user types
        switch ($userType) {
            case 's':
                $select->where
                    ->equalTo('user.access_permit', 2)
                    ->and
                    ->notEqualTo('user.access_permit', 'a');
                break;
            case 't':
                $select->where
                    ->notEqualTo('user.access_permit', 2)
                    ->and
                    ->notEqualTo('user.access_permit', 'a');
                break;
            case 'g':
                $select->where
                    ->equalTo('user_type', 'g');
                break;
        }

        if ($paginated) {
            $paginatorAdapter = new DbSelect($select, $this->sql);
            return new Paginator($paginatorAdapter);
        }

        //        echo $select->getSqlString();

        return $this->sql->prepareStatementForSqlObject($select)->execute();
    }

    public function getScheduleByDay($day, $user)
    {
        $select = $this->sql->select(self::DY_SCHEDULE_TBL);
        $select
            ->where
            ->equalTo('user_id', $user)
            ->and
            ->like('date_created', '%'.$day.'%');

        return $this->sql->prepareStatementForSqlObject($select)->execute();

    }

    public function getStudentByGuardian($id)
    {
        $select = $this->sql->select(['parent' => self::GUARDIAN_TBL]);
        $select
            ->join(['user' => self::USER_TABLE], 'user.id = parent.user_id', ['first_name', 'last_name'], $select::JOIN_LEFT)
            ->join(['level' => self::LEVEL_TBL], 'level.id = user.level', ['level_name' => 'name'], $select::JOIN_LEFT)
            ->join(['section' => self::SECTION_TBL], 'section.id = user.section', ['section_name' => 'name'], $select::JOIN_LEFT);

        $select->where->equalTo('id', $id);

        return $this->sql->prepareStatementForSqlObject($select)->execute();

    }

    public function getTapByDay($day, $user, $withinInterval = 0, $limit = 1)
    {
        $select = $this->sql->select(['parent' => self::ATTENDANCE_TBL]);
        $select->where
            ->equalTo('user_id', $user)
            ->and
            ->equalTo('within_interval', $withinInterval)
            ->and
            ->like('date_created', '%'.$day.'%');
        $select->limit($limit);

        return $this->sql->prepareStatementForSqlObject($select)->execute();
    }

    public function setDatabase($adapter)
    {
        $this->sql = new Sql($adapter);
    }

}