<?php
namespace BaseModule\Service;

use Zend\Cache\Storage\StorageInterface;
use Zend\Config\Config;
use Zend\Db\Sql\Sql;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\View\HelperPluginManager;

abstract class AbstractBaseService implements FactoryInterface
{
    /** @var ServiceLocatorInterface */
    protected $serviceLocator;

    /** @var StorageInterface */
    protected $cache;

    /** @var Sql */
    protected $sql;

    /** @var HelperPluginManager */
    protected $viewHelperManager;

    /** @var Config */
    protected $config;

    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $this->serviceLocator = $serviceLocator;
        $this->config = $this->serviceLocator->get(\BaseModule\Service\Config\Config::class);
        $this->viewHelperManager = $serviceLocator->get('ViewHelperManager');
        $dbAdapter = $serviceLocator->get('Zend\Db\Adapter\Adapter');
        $this->sql = new Sql($dbAdapter);
        $this->cache = $this->serviceLocator->get('Cache\Persistence');
        return $this;
    }
}