<?php
namespace Comitatus\Repository;

use Comitatus\Repository\UserRepository;
use Zend\Authentication\Adapter\DbTable\CallbackCheckAdapter;
use Zend\Crypt\Password\Bcrypt;

class UserRepositoryImpl extends UserRepository
{
    public function add($user)
    {
        $sql =  new \Zend\Db\Sql\Sql($this->adapter);
        $insert = $sql->insert()
            ->values([
                'first_name' => $user->getFirstName(),
                'last_name' => $user->getLastName(),
                'email' => $user->getEmail(),
                'password' => $this->generatePassword($user->getPassoword()),
            ])
            ->into('comitatus_user_account');

        $statement =  $sql->prepareStatementForSqlObject($insert);
        $statement->execute();
    }


    /**
     * @return \Zend\Authentication\Adapter\DbTable\CallbackCheckAdapter
     */
    public function getAuthenticationAdapter()
    {
        $callback = function($encryptedPassword, $clearTextPassword) {
            $encrypter =  new Bcrypt();
            $encrypter->setCost(12);

            $encrypter->verify($clearTextPassword, $encryptedPassword);
        };

        $authenticationAdapter =  new CallbackCheckAdapter(
            $this->adapter,
            'user_tbl',
            'email',
            'password',
            $callback
        );

        return $authenticationAdapter;
    }

    public function generatePassword($clearTextPassword)
    {
        $encrypter =  new Bcrypt();
        $encrypter->setCost(12);

        return $encrypter->create($clearTextPassword);
    }




}