<?php

namespace Comitatus\Form;

use Zend\Form\Form;

class UserSettingsForm extends Form
{
    public function __construct($data)
    {
        parent::__construct('add-profile-form', $options = []);

        $this->add(array(
            'name' => 'id',
            'type' => 'hidden',
            'attributes' => array(
                'id' => 'id',
                'value' => isset($data['id']) ? $data['id'] : '',
            ),
        ));

        $this->add(array(
            'name' => 'notification_charge',
            'type' => 'radio',
            'attributes' => array(
                'id' => 'notification_charge',
                'value' => isset($data['notification_charge']) ? $data['notification_charge'] : 0,
            ),
            'options' => array(
                'value_options' => array(
                    '0' => 'Postpaid',
                    '1' => 'Prepaid',
                ),
            ),
        ));

        $this->add(array(
            'name' => 'has_e_wallet_pin',
            'type' => 'radio',
            'attributes' => array(
                'id' => 'has_e_wallet_pin',
                'value' => isset($data['has_e_wallet_pin']) ? $data['has_e_wallet_pin'] : 0,
            ),
            'options' => array(
                'value_options' => array(
                    '0' => 'Yes',
                    '1' => 'No',
                ),
            ),
        ));

        $this->add(array(
            'name' => 'e_wallet_pin',
            'type' => 'text',
            'attributes' => array(
                'id' => 'e_wallet_pin',
                'value' => isset($data['e_wallet_pin']) ? $data['e_wallet_pin'] : NULL,
            ),
        ));

        $this->add(array(
            'name' => 'max_daily_spending',
            'type' => 'text',
            'attributes' => array(
                'id' => 'max_daily_spending',
                'value' => isset($data['max_daily_spending']) ? $data['max_daily_spending'] : 0,
            ),
        ));

        $this->add(array(
            'name' => 'payment_scheme',
            'type' => 'text',
            'attributes' => array(
                'id' => 'payment_scheme',
                'value' => isset($data['payment_scheme']) ? $data['payment_scheme'] : NULL,
            ),
        ));

        $this->add(array(
            'name' => 'sms_ad',
            'type' => 'text',
            'attributes' => array(
                'id' => 'sms_ad ',
                'value' => isset($data['sms_ad ']) ? $data['sms_ad '] : 0,
            ),
        ));

        $this->add(array(
            'name' => 'email_ad',
            'type' => 'text',
            'attributes' => array(
                'id' => 'email_ad',
                'value' => isset($data['email_ad']) ? $data['email_ad'] : 0,
            ),
        ));
    }
}