<?php

namespace Comitatus\Form;

use Zend\Form\Form as ZendForm;

class SigninForm extends ZendForm
{
    public function __construct($name = null, array $options = [])
    {
        parent::__construct('signin', $options);

        $this->add(array(
            'name'       => 'username',
            'type'       => 'text',
            'options'    => array(
                'label' => 'Email'
            ),
            'attributes' => array(
                'id'          => 'username',
                'class'       => 'form-username form-control custom-input',
                'placeholder' => 'Email',
            ),
        ));

        $this->add(array(
            'name'       => 'password',
            'type'       => 'password',
            'options'    => array(
                'label' => 'Password',
            ),
            'attributes' => array(
                'id'          => 'password',
                'class'       => 'form-login-password form-control custom-input',
                'placeholder' => 'Password',
            ),
        ));

        $this->add(array(
            'name'       => 'remember_me',
            'type'       => 'checkbox',
            'options'    => array(
                'label'              => 'Remember Me',
                'use_hidden_element' => true,
                'checked_value'      => 'yes',
                'unchecked_value'    => 'no',
            ),
            'attributes' => array(
                'id' => 'rememberMe',
            ),
        ));

        $this->add(array(
            'name'    => 'signinCsrf',
            'type'    => 'Zend\Form\Element\Csrf',
            'options' => array(
                'csrf_options' => array(
                    'timeout' => 600
                )
            )
        ));
    }
}