<?php

namespace Comitatus\Form;

use Zend\Form\Form;

class ScheduleForm extends Form
{
    public function __construct($data)
    {
        parent::__construct('edit-schedule-form', []);

        $this->add(array(
            'name'       => 'id',
            'type'       => 'hidden',
            'attributes' => array(
                'id'    => "id",
                'value' => isset($data['id']) ? $data['id'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'name',
            'type'       => 'text',
            'options'    => array(
                'label' => 'Name'
            ),
            'attributes' => array(
                'id'    => 'yearFrom',
                'class' => 'form-control',
                'value' => isset($data['year_start']) ? $data['year_start'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'year_start',
            'type'       => 'date',
            'options'    => array(
                'format' => 'm/d/Y',
                'label'  => 'School Year Start'
            ),
            'attributes' => array(
                'id'    => 'yearFrom',
                'class' => 'form-control',
                'value' => isset($data['year_start']) ? $data['year_start'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'year_end',
            'type'       => 'date',
            'options'    => array(
                'format' => 'm/d/Y',
                'label'  => 'School Year End'
            ),
            'attributes' => array(
                'id'    => 'yearTo',
                'class' => 'form-control',
                'value' => isset($data['year_end']) ? $data['year_end'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'is_active',
            'type'       => 'checkbox',
            'options'    => array(
                'label' => '',
                'checked_value'      => 'true',
                'unchecked_value'    => 'false',
            ),
            'attributes' => array(
                'id'    => 'activeSchedule',
                'class' => 'reward-system',
                'value' => isset($data['is_active']) ? $data['is_active'] : '',
            ),
        ));

    }
}