<?php

namespace Comitatus\Form;

use Zend\Form\Form;

class AppSettingsForm extends Form
{
    public function __construct($data)
    {
        parent::__construct('edit-settings-form', []);

        $this->add(array(
            'name'       => 'id',
            'type'       => 'hidden',
            'attributes' => array(
                'id'    => "id",
                'value' => isset($data['id']) ? $data['id'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'default_theme',
            'type'       => 'select',
            'options'    => array(
                'label'                     => 'Default Theme',
                'value_options'             => [
                    ''                  => '-- Select --',
                    'skin-blue'         => 'Blue',
                    'skin-blue-light'   => 'Blue Light',
                    'skin-yellow'       => 'Yellow',
                    'skin-yellow-light' => 'Yellow Light',
                    'skin-green'        => 'Green',
                    'skin-green-light'  => 'Green Light',
                    'skin-purple'       => 'Purple',
                    'skin-purple-light' => 'Purple Light',
                    'skin-red'          => 'Red',
                    'skin-red-light'    => 'Red Light',
                    'skin-black'        => 'Black',
                    'skin-black-light'  => 'Black Light',
                ],
                'disable_inarray_validator' => true,
            ),
            'attributes' => array(
                'id'    => 'themeSelector',
                'class' => 'form-control',
                'value' => isset($data['default_theme']) ? $data['default_theme'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'idle_time',
            'type'       => 'select',
            'options'    => array(
                'label'                     => 'Auto Logout after (in minutes):',
                'value_options'             => [
                    ''                  => '-- Select --',
                    'skin-blue'         => 'Blue',
                    'skin-blue-light'   => 'Blue Light',
                    'skin-yellow'       => 'Yellow',
                    'skin-yellow-light' => 'Yellow Light',
                    'skin-green'        => 'Green',
                    'skin-green-light'  => 'Green Light',
                    'skin-purple'       => 'Purple',
                    'skin-purple-light' => 'Purple Light',
                    'skin-red'          => 'Red',
                    'skin-red-light'    => 'Red Light',
                    'skin-black'        => 'Black',
                    'skin-black-light'  => 'Black Light',
                ],
                'disable_inarray_validator' => true,
            ),
            'attributes' => array(
                'id'    => 'idleTimeSelector',
                'class' => 'form-control',
                'value' => isset($data['idle_time']) ? $data['idle_time'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'idle_time_other',
            'type'       => 'number',
            'options'    => array(
                'label' => 'Other'
            ),
            'attributes' => array(
                'id'          => 'maxSMS',
                'class'       => 'form-control',
                'value'       => isset($data['idle_time_other']) ? $data['idle_time_other'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'max_sms',
            'type'       => 'number',
            'options'    => array(
                'label' => 'Maximum SMS number for attendance notification:'
            ),
            'attributes' => array(
                'id'          => 'maxSMS',
                'class'       => 'form-control',
                'value'       => isset($data['max_sms']) ? $data['max_sms'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'max_credit',
            'type'       => 'number',
            'options'    => array(
                'label' => 'Maximum credit limit (₱):'
            ),
            'attributes' => array(
                'id'          => 'maxCredit',
                'class'       => 'form-control',
                'value'       => isset($data['max_credit']) ? $data['max_credit'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'reward_system',
            'type'       => 'checkbox',
            'options'    => array(
                'label' => 'Maximum credit limit (₱):'
            ),
            'attributes' => array(
                'class'       => 'reward-system',
                'value'       => isset($data['reward_system']) ? $data['reward_system'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'conversion_points',
            'type'       => 'text',
            'options'    => array(
                'label' => ''
            ),
            'attributes' => array(
                'class'       => 'form-control conversion-points',
                'value'       => isset($data['conversion_points']) ? $data['conversion_points'] : '',
            ),
        ));

        $this->add(array(
            'name'       => 'conversion_amount',
            'type'       => 'text',
            'options'    => array(
                'label' => ''
            ),
            'attributes' => array(
                'class'       => 'form-control conversion-amount',
                'value'       => isset($data['conversion_amount']) ? $data['conversion_amount'] : '',
            ),
        ));
    }
}