<?php

namespace Comitatus\Filter;

use Comitatus\Service\Database\DatabaseService;
use Comitatus\Validator\FieldExistValidator;
use Zend\InputFilter\InputFilter;
use Zend\Validator\Digits;
use Zend\Validator\NotEmpty;

class ProductFilter extends InputFilter
{
    public function __construct($serviceLocator)
    {
        $this->add(array(
            'name'       => 'picture',
            'required'   => false,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'       => 'category',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'name',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
                array(
                    'name'                   => 'Comitatus\Validator\FieldExistValidator',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'serviceLocator' => $serviceLocator,
                        'table'          => DatabaseService::CANTEEN_TBL,
                        'column'         => 'name',
                        'messages' => array(
                            FieldExistValidator::VALUE_EXIST => 'Product name is in use.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'description',
            'required'   => false,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'       => 'bar_code',
            'required'   => false,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
        ));

        $this->add(array(
            'name'       => 'price',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'facilities',
            'required'   => true,
            'filters'    => array(
                array('name' => 'Zend\Filter\StringTrim'),
            ),
            'validators' => array(
                array(
                    'name'                   => 'Zend\Validator\NotEmpty',
                    'break_chain_on_failure' => true,
                    'options'                => array(
                        'messages' => array(
                            NotEmpty::IS_EMPTY => 'This is required.',
                        ),
                    ),
                ),
            ),
        ));

        $this->add(array(
            'name'       => 'can_preorder',
            'required'   => false,
        ));
    }
}