<?php

namespace Comitatus\Controller;

use Comitatus\Filter\AppSettingsFilter;
use Comitatus\Form\AppSettingsForm;
use Comitatus\Service\Database\DatabaseService;
use Zend\View\Model\JsonModel;

class SystemSettingsController extends BaseController
{
    const SKINS = [
        'bg-primary header-text-light'   => 'Blue',
        'bg-secondary header-text-light' => 'Gray',
        'bg-success header-text-dark'    => 'Green',
        'bg-info header-text-dark'       => 'Light Blue',
        'bg-warning header-text-dark'    => 'Yellow',
        'bg-danger header-text-light'    => 'Red',
        'bg-light header-text-dark'      => 'Light',
        'bg-dark header-text-light'      => 'Dark',
        'bg-focus header-text-light'     => 'Focus',
        'bg-alternate header-text-light' => 'Alternate',
    ];
    
    public function indexAction()
    {
        $settings = $this->databaseService->selectData(DatabaseService::APP_SETTINGS_TBL, ['school_id' => $this->sessionContainer->offsetGet('school_db')])->current();
        
        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $action = strtolower($this->params('param1'));
            
            switch ($action) {
                case 'save':
                    $data       = $this->params()->fromPost('data', []);
                    $validation = $this->validate($data);
                    if ($validation['status'] == 0) {
                        return new JsonModel([
                            'status'  => 0,
                            'message' => 'Validation failed!',
                            'errors'  => $validation['message'],
                        ]);
                    }
                    
                    $result = $this->save($data);
                    
                    return new JsonModel($result);
                    break;
                default:
                    break;
            }
        }
        
        return [
            'appSettings' => $settings,
            'skins'       => self::SKINS,
        ];
    }
    
    private function validate($data)
    {
        
        $form   = new AppSettingsForm($data);
        $filter = new AppSettingsFilter($this->serviceLocator);
        
        $form->setInputFilter($filter);
        $form->setData($data);
        
        if ($form->isValid()) {
            $return['status']  = 1;
            $return['message'] = [];
        } else {
            $return['status']  = 0;
            $return['message'] = $filter->getMessages();
        }
        
        return $return;
    }
    
    private function save($data)
    {
        $return = [];
        
        $settings                = $data;
        $settings['modified_by'] = $this->userModified;
        
        if (!empty($settings['idle_time_other']))
            $settings['idle_time'] = $settings['idle_time_other'];
        unset($settings['idle_time_other']);
        
        //If banner doesn't exist,
        if ($data['id'] == '') {
            unset($settings['id']);
            $settings['date_created'] = date('Y-m-d H:i:s');
            $settings['school_id']    = $this->sessionContainer->offsetGet('school_db');
            $this->databaseService->createData(DatabaseService::APP_SETTINGS_TBL, $settings);
            $return['status']  = 1;
            $return['message'] = 'Settings Saved Successfully!';
            
        } else {
            $this->databaseService->updateData(DatabaseService::APP_SETTINGS_TBL, $settings);
            $return['status']  = 1;
            $return['message'] = 'Settings Updated Successfully!';
        }
        
        return $return;
    }
}