<?php

namespace Comitatus\Controller;

use Comitatus\Filter\SigninFilter;
use Comitatus\Form\SigninForm;
use Comitatus\Service\Database\DatabaseService;
use Zend\Config\Config;
use Zend\Db\Adapter\Adapter;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\Mvc\MvcEvent;
use Zend\Session\Container;
use Zend\View\Model\JsonModel;

class SigninController extends AbstractActionController
{
    /** @var DatabaseService */
    protected $databaseService;
    
    /** @var Config */
    protected $config;
    
    /** @var Container */
    protected $sessionContainer;
    
    public function indexAction()
    {
        if (!file_exists(__DIR__ . '/../Filter/SigninFilter.php')) {
            echo __DIR__ . '/../Filter/SigninFilter.php';
        }
        
        $form = new SigninForm([]);
        
        // check if user session exist;
        if (strtolower($this->getRequest()->getMethod()) == 'post') {
            $action   = strtolower($this->params('param1'));
            $username = $this->params()->fromPost('username');
            $password = $this->params()->fromPost('password');
            $data     = [
                'username' => $username,
                'password' => $password,
            ];
            
            // validate username and password
            $isValid = $this->validate($data);
            if ($isValid['status'] == 0) {
                return new JsonModel([
                    'status'  => 0,
                    'message' => 'Validation failed!',
                    'errors'  => $isValid['message'],
                ]);
            }
            
            // signin
            $signin = $this->signIn($data);
            
            if ($signin['status'] == 0) {
                return new JsonModel([
                    'status'  => 0,
                    'message' => 'Validation failed!',
                    'errors'  => ['signin' => $signin['msg']],
                ]);
            }
            
            return new JsonModel([
                'status'   => 1,
                'message'  => 'Validation success!',
                'is_admin' => $signin['is_admin'],
            ]);
        }
        
        return [
            'form' => $form,
        ];
    }
    
    private function validate($data)
    {
        $form   = new SigninForm($data);
        $filter = new SigninFilter();
        
        $form->setInputFilter($filter);
        $form->setData($data);
        
        if ($form->isValid()) {
            $result['status']  = 1;
            $result['message'] = [];
        } else {
            $result['status']  = 0;
            $result['message'] = $filter->getMessages();
        }
        
        return $result;
    }
    
    private function signIn($data)
    {
        // check which database
        $dbNumber = 0;
        if (substr($data['username'], 0, 5) == 'admin') {
            //            $adapterData = $this->config['db'];
            $isAdmin = 1;
        } else {
            $isAdmin     = 0;
            $dbNumber    = substr($data['username'], 2, 1);
            $adapterData = $this->config['db']['adapters']['db_' . $dbNumber];
            if (isset($adapterData)) {
                //                $adapter = new Adapter($adapterData);
                $adapter = $this->serviceLocator->get('db_' . $dbNumber);
                $this->databaseService->setDatabase($adapter);
            }
        }
        
        $this->sessionContainer->offsetSet('school_db', $dbNumber);
        $this->sessionContainer->offsetSet('is_dev', $isAdmin);
        
        $isAuthenticated = $this->databaseService->selectData(DatabaseService::USER_TABLE, ['user_id' => $data['username'], 'account_close' => 0]);
        
        if ($isAuthenticated->count()) {
            $user             = $isAuthenticated->current();
            $user['is_admin'] = $isAdmin;
            $isVerified       = password_verify($data['password'], $user['password']);
            
            if (!$isVerified) {
                return [
                    'status' => 0,
                    'msg'    => '* Username or password is incorrect.'
                ];
            }
            
            // get user settings
            if (!$isAdmin) {
                $userSettings  = $this->databaseService->selectData(DatabaseService::USER_SETTINGS_TBL, ['user_id' => $user['id']]);
                $user['theme'] = $userSettings->count() && isset($userSettings->current()['theme']) ? $userSettings->current()['theme'] : '';
            } else $user['theme'] = '';
            
            // store the user information on session
            $this->sessionContainer->offsetSet('current_user', $user);
            return [
                'status'   => 1,
                'msg'      => '* Session started.',
                'is_admin' => $isAdmin,
            ];
            
        }
        
        return [
            'status' => 0,
            'msg'    => '* Account not recognized.'
        ];
        
    }
    
    public function onDispatch(MvcEvent $e)
    {
        $this->layout('layout/signin-layout');
        $this->databaseService = $this->serviceLocator->get(DatabaseService::class);
        $this->config          = $this->serviceLocator->get('Config');
        
        $this->sessionContainer = new Container('comitatus');
        
        return parent::onDispatch($e);
    }
    
    
}