<?php

namespace Comitatus\Controller\Rest;

use Comitatus\Controller\BaseController;
use Comitatus\Service\Database\DatabaseService;
use Zend\View\Model\JsonModel;

class ApiController extends BaseController
{
    public function indexAction()
    {
        return new JsonModel(['status' => 0, 'msg' => 'invalid request!']);
    }

    public function searchUserAction()
    {

        $search = $this->params()->fromQuery('search');
        $hits   = [];

        if ($search != '') {
            $columns = ['user_id', 'card_id', 'first_name', 'middle_name', 'last_name'];
            $result  = $this->accountManager->searchUser($search, $columns);

            if (count($result)) {
                foreach ($result as $key => $value) {
                    $arr        = [
                        'id'           => $value['id'],
                        'user_id'      => $value['user_id'],
                        'card_id'      => $value['card_id'],
                        'first_name'   => $value['first_name'],
                        'middle_name'  => $value['middle_name'],
                        'last_name'    => $value['last_name'],
                        'picture'      => $this->config['upload_url'] . '/users/' . $value['picture'],
                        'level_id'     => $value['level'],
                        'level_name'   => $value['level_name'],
                        'section_id'   => $value['section'],
                        'section_name' => $value['section_name'],
                        'role'         => $value['access_permit'],
                    ];
                    $hits[$key] = $arr;
                }
            }
            return new JsonModel(['hits' => $hits]);

        }

        return new JsonModel(['status' => 0, 'msg' => 'invalid request!']);

    }


    public function getUserAction()
    {
        /** $types:
         * attendance
         * basic
         * canteen
         * wallet
         * wallet_history
         * wallet_transactions
         * settings
         * guardians
         * grades
         * subjects
         * bills
         * schedules
         */
        $type = $this->params()->fromQuery('type', 'all');
        $id   = $this->params()->fromQuery('id');

        if (intval($id)) {
            $user = $this->accountManager->getAllUserInfo($id);

            if ($type != 'all') {
                $user = $user[$type];
            }

            return new JsonModel($user);
        }

        return new JsonModel(['status' => 0, 'msg' => 'invalid request!']);
    }

    public function getSectionByLevelAction()
    {
        $levelId  = $this->params()->fromPost('level_id');
        $sections = $this->databaseService->selectData(DatabaseService::SECTION_TBL, ['level_id' => $levelId, 'is_archive' => 0], ["name ASC"]);
        $arr      = [];

        if ($sections->count()) {
            foreach ($sections as $section) {
                $arr[] = $section;
            }
        }

        return new JsonModel(['sections' => $arr]);
    }

}