<?php

namespace Comitatus\Controller;

use Comitatus\Service\Account\AccountManager;
use Comitatus\Service\Attendance\AttendanceManager;
use Comitatus\Service\Database\DatabaseService;
use Zend\Db\Adapter\Adapter;
use Zend\View\Model\JsonModel;

class AttendanceController extends BaseController
{
    CONST FLAG       = ['On Time', 'Late', 'No Schedule'];
    CONST FLAG_COLOR = ['text-success', 'text-danger', 'text-warning'];
    
    public function indexAction()
    {
        // data processing
        $role      = $this->sessionContainer->offsetGet('current_user')['role'];
        $isTeacher = $this->accountManager->getAccessRight($role) == AccountManager::ACCESS_TEACHER;
        
        // select data population
        $levels      = $this->databaseService->selectData(DatabaseService::LEVEL_TBL, ['is_archive' => 0]);
        $allSections = [];
        
        // post data collection
        $level          = $this->params()->fromQuery('level', '');
        $section        = $this->params()->fromQuery('section', '');
        $dateRange      = $this->params()->fromQuery('date-range', '');
        $userType       = $this->params()->fromQuery('user-type', 'a');
        $displayResults = 0;
        $where          = [];
        $range          = [];
        if ($level != '') {
            $allSections = $this->databaseService->selectData(DatabaseService::SECTION_TBL, ['level_id' => $level, 'is_archive' => 0], ['name ASC']);
            
            $where['user.level'] = $level;
            if ($section != '')
                $where['user.section'] = $section;
            $displayResults = 1;
            
        }
        
        if ($dateRange != '') {
            $dates = explode(' - ', $dateRange);
            $start = date('Y-m-d', strtotime($dates[0]));
            $end   = date('Y-m-d', strtotime($dates[1]));
            
            $range          = [$start . ' 00:00:00', $end . ' 23:59:59'];
            $displayResults = 1;
            
        } else {
            $now            = date('Y-m-d');
            $range          = [$now . ' 00:00:00', $now . ' 23:59:59'];
            $displayResults = 1;
        }
        
        if ($userType != ' ') {
            $displayResults = 1;
        }
        
        $records = $this->attendanceService()->getAllAttendanceRecords($userType, $where, $range);
        
        return [
            'is_admin'        => $this->sessionContainer->offsetGet('current_user')['is_admin'],
            'is_teacher'      => $isTeacher,
            'displayResults'  => $displayResults,
            'levels'          => $levels,
            'sections'        => $allSections,
            'records'         => $records,
            'user_type'       => $userType,
            'current_level'   => $level,
            'current_section' => $section,
            'date_range'      => $dateRange,
            'flags'           => self::FLAG,
            'flag_color'      => self::FLAG_COLOR,
        ];
    }
    
    public function newRecordAction()
    {
        $role       = $this->sessionContainer->offsetGet('current_user')['role'];
        $isSecurity = $this->accountManager->getAccessRight($role) == AccountManager::ACCESS_SECURITY;
        
        return [
            'is_security' => $isSecurity,
            'is_admin'    => $this->sessionContainer->offsetGet('current_user')['is_admin'],
        ];
    }
    
    public function getScheduleByUserAction()
    {
        // variable initialization
        $id               = $this->params()->fromPost('id');
        $fullName         = $this->params()->fromPost('full_name');
        $userType         = $this->params()->fromPost('user_type', 'student');
        $isManual         = $this->params()->fromPost('is_manual', 0);
        $currentDay       = date('l');
        $currentTime      = date('H:i:s');
        $currentDate      = date('m-d-Y');
        $currentDateTime  = date('Y-m-d H:i:s');
        $sendNotification = true;
        $withinInterval   = 0;
        $flag             = 0;
        $sendSms          = 0;
        $sendEmail        = '';
        $tapCount         = [];
        $notificationData = [];
        $students         = [];
        
        /* get app settings
            max sms is 4 but added 1 for restriction
            go send if tap count > max sms allowed */
        $maxSms      = 5;
        $creditLimit = 0;
        $appSettings = $this->databaseService->selectData(DatabaseService::APP_SETTINGS_TBL)->current();
        $maxSms      = isset($appSettings['max_sms']) ? intval($appSettings['max_sms']) + 1 : $maxSms;
        $creditLimit = isset($appSettings['max_credit']) ? $appSettings['max_credit'] : 0;
        
        if ($userType == 'student') {
            
            // get user related settings and information
            $schedule = $this->databaseService->selectData(DatabaseService::DY_SCHEDULE_TBL, ['day' => $currentDay, 'user_id' => $id, ' is_restday' => 0]);
            $settings = $this->databaseService->selectData(DatabaseService:: USER_SETTINGS_TBL, ['user_id' => $id])->current();
            $credits  = isset($settings['notification_charge']) ? $settings['notification_charge'] : 0;
            
            if ($schedule->count()) {
                $userSchedule = $schedule->current();
                
                if ($userSchedule['time_in_period'] == 'PM') {
                    $inHour = date('H', strtotime($userSchedule['time_in']));
                    if ($inHour != '12') {
                        // if schedule is beyond 12pm add 12 hours for computation
                        $userSchedule['time_in'] = date('H:i:s', strtotime($userSchedule['time_in']) + 43200);
                    } else {
                        $userSchedule['time_in'] = date('H:i:s', strtotime($userSchedule['time_in']));
                    }
                }
                if ($userSchedule['time_out_period'] == 'PM') {
                    $outHour = date('H', strtotime($userSchedule['time_out']));
                    if ($outHour != '12') {
                        // if schedule is beyond 12pm add 12 hours for computation
                        $userSchedule['time_out'] = date('H:i:s', strtotime($userSchedule['time_out']) + 43200);
                    } else {
                        $userSchedule['time_out'] = date('H:i:s', strtotime($userSchedule['time_out']));
                    }
                }
                
                $timeChecker = $this->attendanceService()->getScheduleByDay($id, date('Y-m-d'));
                if (!$timeChecker->count()) {
                    if ($currentTime > $userSchedule['time_in'])
                        $flag = 1;
                }
                
                if ($currentTime > $userSchedule['time_out'])
                    $flag = 2;
                
            } else $flag = 2;
            
            // check if last tap is within 30mins
            $lastTap = $this->attendanceService()->getTapByDay(date('Y-m-d'), $id);
            if (count($lastTap->current())) {
                if (date('Y-m-d H:i:s a', strtotime($lastTap->current()['date_created'])) > date('Y-m-d H:i:s a', strtotime("-30 minutes"))) {
                    $sendNotification = false;
                    $withinInterval   = 1;
                }
            }
            
            // record tap
            $this->databaseService->createData(DatabaseService::ATTENDANCE_TBL,
                [
                    'user_id'         => $id,
                    'time_log'        => $currentDateTime,
                    'flag_late'       => $flag,
                    'is_manual'       => $isManual,
                    'within_interval' => $withinInterval,
                    'date_created'    => $currentDateTime,
                    'modified_by'     => $isManual == 1 ? $this->userModified : $id,
                ]
            );
            
            // get tap count that is not within interval
            $cardTaps = $this->attendanceService()->getTapByDay(date('Y-m-d'), $id, 0, 10);
            
            // get guardians if the user who tap is student
            $guardians = $this->databaseService->selectData(DatabaseService::GUARDIAN_TBL, ['user_id' => $id]);
            
            if ($guardians->count()) {
                $currentBalance = [];
                
                foreach ($guardians as $gKey => $gValue) {
                    $dateTime = date('Y-m-d h:i:s a');
                    
                    if ($gValue['email_notification'] == 1) {
                        $emailData                   = [
                            'full_name' => $fullName,
                            'date_time' => $dateTime,
                            'email'     => $gValue['email']
                        ];
                        $notificationData['email'][] = $emailData;
                    }
                    
                    if ($gValue['sms_notification'] == 1) {
                        
                        if ($cardTaps->count() < $maxSms) {
                            // check user's current balance
                            $checkBalance   = $this->databaseService->selectData(DatabaseService::USER_WALLET_TBL, ['user_id' => $id]);
                            $currentBalance = $checkBalance->current();
                            
                            if ($checkBalance->count()) {
                                $goSend = 0;
                                
                                if ($credits) {
                                    //if (floatval($currentBalance['postpaid_balance']) < $creditLimit)
                                    $goSend = 1;
                                } else {
                                    $currentPrepaidBalance = floatval($currentBalance['prepaid_balance']);
                                    if ($currentPrepaidBalance <= 0) {
                                        // credit limit is up to its negative value on prepaid.
                                        $creditLimit = -($creditLimit);
                                    }
                                    
                                    //                                    if ($currentPrepaidBalance > floatval($creditLimit))
                                    //                                        $goSend = 1;
                                    
                                    // if not yet on limit go send
                                    if ($currentPrepaidBalance > floatval($creditLimit))
                                        $goSend = 1;
                                }
                                
                                if ($goSend) {
                                    $contact1 = '';
                                    $contact2 = '';
                                    
                                    if ($gValue['contact1'] != '') {
                                        $contact1 = $gValue['contact1'];
                                        $sendSms++;
                                    }
                                    if ($gValue['contact2'] != '') {
                                        $contact2 = $gValue['contact2'];
                                        $sendSms++;
                                    }
                                    
                                    $s = [
                                        'full_name' => $fullName,
                                        'date_time' => $dateTime,
                                        'contact1'  => $contact1,
                                        'contact2'  => $contact2
                                    ];
                                    
                                    $notificationData['sms'][$gValue['id']] = $s;
                                }
                                
                            }
                        }
                    }
                }
                
                if ($sendSms > 0) {
                    $transaction = [
                        'user_id'      => $id,
                        'type'         => 'SMS notification',
                        'amount'       => $sendSms,
                        'modified_by'  => $this->userModified,
                        'date_created' => $currentDateTime
                    ];
                    $this->databaseService->createData(DatabaseService::WALLET_TRANS_TBL, $transaction);
                    
                    $onLimit = 0;
                    if ($credits) {
                        $column = 'postpaid_balance';
                        
                        // omitting this line since postpaid should not be charged for attendance
                        //                    $newBalance = $currentBalance['postpaid_balance'] + $transaction['amount'];
                        //                    if ($currentBalance['postpaid_balance'] == $creditLimit)
                        //                        $onLimit = 1;
                    } else {
                        $column = 'prepaid_balance';
                        
                        if ($currentBalance['prepaid_balance'] < 0) {
                            $newBalance = $currentBalance['prepaid_balance'] + (-$transaction['amount']);
                        } else $newBalance = $currentBalance['prepaid_balance'] - $transaction['amount'];
                        
                        if (!$onLimit)
                            $this->databaseService->updateData(DatabaseService::USER_WALLET_TBL, [$column => $newBalance, 'user_id' => $id], 'user_id');
                        else unset($notificationData['sms']);
                    }
                }
            }
            
            // set notification data to a session variable
            $notificationData['token'] = md5(uniqid());
            $this->sessionContainer->offsetSet('notification_data', $notificationData);
            
        } else {
            $guardians = $this->databaseService->selectData(DatabaseService::GUARDIAN_TBL, ['id' => $id]);
            
            if ($guardians->count()) {
                $currentGuardian = $guardians->current();
                
                // get the students associated to the guardian
                $students = $this->attendanceService()->getStudentByGuardian($id);
                
                $this->databaseService->createData(
                    DatabaseService::ATTENDANCE_TBL,
                    [
                        'user_id'      => $currentGuardian['id'],
                        'user_type'    => 'g',
                        'time_log'     => $currentDateTime,
                        'flag_late'    => $flag,
                        'is_manual'    => $isManual,
                        'date_created' => $currentDateTime,
                        'modified_by'  => $isManual == 1 ? $this->userModified : $currentGuardian['id'],
                    ]
                );
            }
        }
        
        return new JsonModel([
            'students'          => $students,
            'send_notification' => $sendNotification,
            'flag'              => $flag,
        ]);
    }
    
    public function sendNotificationsAction()
    {
        $hasNotification = $this->sessionContainer->offsetExists('notification_data');
        
        if ($hasNotification) {
            $notificationData = $this->sessionContainer->offsetGet('notification_data');
            $smsSent          = [];
            $emailSent        = [];
            
            if (count($notificationData)) {
                // date format for sql date_created
                $sqlDate = date('Y-m-d H:i:s');
                
                if (isset($notificationData['email']) AND count($notificationData['email']) > 0) {
                    foreach ($notificationData['email'] as $key => $value) {
                        $fullName = $value['full_name'];
                        $dateTime = $value['date_time'];
                        
                        // email content
                        $subject = 'Attendance Notification';
                        $body    = "<p>Hello Guardian,</p>" . "<p><strong> $fullName</strong> has checked in/out at school: $dateTime.</p><br>" . "<p>Thanks,<br>School Admin</p>";
                        
                        // send email notification
                        if (isset($value['email']) AND $value['email'] != '') {
                            
                            $sendEmail = $this->emailManager->sendEmail($value['email'], $subject, $body);
                            if ($sendEmail['sent'] == true) {
                                
                                // create sms logs
                                $emailLog = [
                                    'recipient'    => $value['email'],
                                    'message'      => $subject . $body,
                                    'type'         => 'attendance-notification',
                                    'token'        => $notificationData['token'],
                                    'date_created' => $sqlDate,
                                    'modified_by'  => $this->userModified,
                                ];
                                $this->databaseService->createData(DatabaseService::EMAIL_LOGS_TBL, $emailLog);
                                $emailSent[] = $value['email'];
                            }
                        }
                    }
                }
                
                if (isset($notificationData['sms']) AND count($notificationData['sms']) > 0) {
                    foreach ($notificationData['sms'] as $key => $value) {
                        $fullName = $value['full_name'];
                        $dateTime = $value['date_time'];
                        
                        // sms content
                        $message = 'Hello guardian, ' . $fullName . ' has checked in/out at school: ' . $dateTime;
                        
                        // send SMS notification
                        if (isset($value['contact1']) AND $value['contact1'] != '') {
                            $sendSms = $this->smsManager->sendTextMsg($value['contact1'], $message);
                            if ($sendSms == 0) {
                                // create sms logs
                                $smsLog = [
                                    'recipient'    => $value['contact1'],
                                    'message'      => $message,
                                    'type'         => 'attendance-notification',
                                    'token'        => $notificationData['token'],
                                    'date_created' => $sqlDate,
                                    'modified_by'  => $this->userModified,
                                ];
                                $this->databaseService->createData(DatabaseService::SMS_LOGS_TBL, $smsLog);
                                $smsSent[] = $value['contact1'];
                            }
                            
                        }
                        if (isset($value['contact2']) AND $value['contact2'] != '') {
                            $sendSms = $this->smsManager->sendTextMsg($value['contact2'], $message);
                            if ($sendSms == 0) {
                                // create sms logs
                                $smsLog = [
                                    'recipient'    => $value['contact2'],
                                    'message'      => $message,
                                    'type'         => 'attendance-notification',
                                    'date_created' => $dateTime,
                                    'modified_by'  => $this->userModified,
                                ];
                                $this->databaseService->createData(DatabaseService::SMS_LOGS_TBL, $smsLog);
                                $smsSent[] = $value['contact2'];
                            }
                        }
                    }
                }
                
                // empty session variable
                $_SESSION['old_token'] = $notificationData['token'];
                $this->sessionContainer->offsetUnset('notification_data');
            }
            
            // return json response
            return new JsonModel(['sms_sent_recipients' => $smsSent, 'email_sent_recipients' => $emailSent]);
        }
    }
    
    public function accessDeniedAction()
    {
        return new JsonModel(['status' => 0]);
    }
    
    private function attendanceService()
    {
        /** @var AttendanceManager $attendanceManager */
        $service = $this->serviceLocator->get(AttendanceManager::class);
        
        // set DB adapter
        $adapter = $this->serviceLocator->get('db_' . $this->sessionContainer->offsetGet('school_db'));
        $service->setDatabase($adapter);
        
        return $service;
    }
}