<?php

namespace Comitatus\Controller;

use Comitatus\Service\Database\DatabaseService;
use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;

class AnnouncementController extends BaseController
{
    public function indexAction()
    {
        $action = $this->params('param1');

        switch ($action) {
            case 'send':
                $targetAudience = $this->params()->fromPost('target_audience');
                $isSms          = $this->params()->fromPost('is_sms');
                $isEmail        = $this->params()->fromPost('is_email');
                $subject        = $this->params()->fromPost('subject');
                $body           = $this->params()->fromPost('body');

                $smsSent   = 0;
                $emailSent = 0;

                $content = ['subject' => $subject, 'body' => $body];
                $to      = $this->getUsersDetails($targetAudience);


                if ($isSms)
                    $emailSent = $this->sendBulkSms($content, $to['numbers']);
                if ($isEmail)
                    $smsSent = $this->sendBulkEmail($content, $to['emails']);

                return new JsonModel(['status' => 1, 'sms_sent' => $smsSent, 'email_sent' => $emailSent, 'msg' => 'Announcement Sent!']);

                break;
            case 'send-sms':
                $recipient  = $this->params()->fromPost('recipient');
                $message    = $this->params()->fromPost('message');
                $instantMsg = $this->sendInstantSms($message, $recipient);

                return new JsonModel($instantMsg);
                break;
            default:
                return [];
                break;
        }
    }

    public function smsBlasterAction()
    {
        return [];
    }

    private function getUsersDetails($type)
    {
        $phoneNumbers = [];
        $emails       = [];
        $allGuardians = [];

        switch ($type) {
            case 1: // students
                $users = $this->accountManager->getAllStudents();
                break;
            case 2: // staffs
                $users = $this->accountManager->getAllStaff();
                break;
            case 3: // guardians
                $allGuardians = $this->accountManager->getAllGuardians();
                break;
            default: // all users
                $allGuardians = $this->accountManager->getAllGuardians();
                $users        = $this->databaseService->selectData(DatabaseService::USER_TABLE, ['account_close' => 0]);

                break;
        }

        if (count($users)) {
            foreach ($users as $key => $value) {
                if ($value['email'])
                    $emails[] = $value['email'];
                if ($value['mobile_number'])
                    $phoneNumbers[] = $value['mobile_number'];
            }
        }

        if (count($allGuardians)) {
            foreach ($allGuardians as $g => $guardian) {

                if ($guardian['email_notification'] && !empty($guardian['email']))
                    $emails[] = $guardian['email'];
                if ($guardian['sms_notification'] && !empty($guardian['contact1']))
                    $phoneNumbers[] = $guardian['contact1'];
                if ($guardian['sms_notification'] && !empty($guardian['contact2']))
                    $phoneNumbers[] = $guardian['contact2'];

            }
        }

        return ['emails' => $emails, 'numbers' => $phoneNumbers];
    }

    private function sendBulkEmail($content = [], $emails = [])
    {
        $dateNow   = date('Y-m-d h:i:s');
        $subject   = 'Announcement: ' . $content['subject'];
        $rawBody   = $content['body'];
        $emailSent = 0;

        $renderer = $this->serviceLocator->get('ViewRenderer');
        $page     = $renderer->render('comitatus/announcement/announcement-email');
        $body     = str_replace('!!EMAIL_BODY!!', $rawBody, $page);

        if (count($emails)) {

            foreach ($emails as $email) {
                $sendMail = $this->emailManager->sendEmail($email, $subject, $body);

                if ($sendMail['sent']) {
                    $emailSent++;

                    // create email logs
                    $emailLog = [
                        'recipient'    => $email,
                        'message'      => "[$subject] $rawBody",
                        'type'         => 'email-announcement',
                        'token'        => md5($dateNow),
                        'date_created' => $dateNow,
                        'modified_by'  => $this->userModified,
                    ];

                    $this->databaseService->createData(DatabaseService::EMAIL_LOGS_TBL, $emailLog);
                }
            }

            return ['status' => 1, 'msg' => 'Email Sent', 'count' => $emailSent];
        }

        return ['status' => 0, 'msg' => 'Something went wrong'];
    }

    private function sendBulkSms($content = [], $numbers = [])
    {
        $dateNow   = date('Y-m-d h:i:s');
        $subject = $content['subject'];
        $body    = $content['body'];
        $smsSent = 0;

        if (count($numbers)) {
            foreach ($numbers as $number) {
                $msg  = "Announcement: $subject. $body.";
                $sent = $this->smsManager->sendTextMsg($number, $msg);
                if (intval($sent) == 0) {
                    $smsSent++;

                    // create sms logs
                    $smsLog = [
                        'recipient'    => $number,
                        'message'      => $msg,
                        'type'         => 'sms-announcement',
                        'token'        => md5($dateNow),
                        'date_created' => date('Y-m-d h:i:s'),
                        'modified_by'  => $this->userModified,
                    ];

                    $this->databaseService->createData(DatabaseService::SMS_LOGS_TBL, $smsLog);

                }
            }
            return ['status' => 1, 'msg' => 'Message Sent', 'count' => $smsSent];
        }

        return ['status' => 0, 'msg' => 'Something went wrong'];
    }

    private function sendInstantSms($message, $number)
    {
        $dateNow   = date('Y-m-d h:i:s');

        if ($message != '' && $number != '') {
            $status = $this->smsManager->sendTextMsg($number, $message);
            if (intval($status) == 0) {
                $smsLog = [
                    'recipient'    => $number,
                    'message'      => $message,
                    'type'         => 'sms-blaster',
                    'token'        => md5($dateNow),
                    'date_created' => $dateNow,
                    'modified_by'  => $this->userModified,
                ];

                $this->databaseService->createData(DatabaseService::SMS_LOGS_TBL, $smsLog);

                return ['status' => 1, 'msg' => 'Message Sent'];
            }

            return ['status' => 0, 'msg' => 'Message Not Sent'];
        }

        return ['status' => 0, 'msg' => 'Something went wrong'];
    }


}