<?php
define('SITE_NAME', 'comitatus');

register_shutdown_function(function() {
    $errors = error_get_last();
    if($errors) {
        echo '<h1>Under Maintenance!</h1>';
        echo '<script>console.log('.json_encode($errors).')</script>';
    }
});

// Decline static file requests back to the PHP built-in webserver
if (php_sapi_name() === 'cli-server') {
    $path = realpath(__DIR__ . parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    if (__FILE__ !== $path && is_file($path)) {
        return false;
    }
    unset($path);
}

// Environment initial setup
//$hostName = preg_replace('/[0-9]+$/', '', strtolower(gethostname()));
$httpHost = $_SERVER['HTTP_HOST'];

switch($httpHost) {
    // Local
    default:
        define('ENV', 'local');
        define('PUBLIC_PATH', __DIR__);
        define('LIBS_PATH', __DIR__.'/../../libraries');
        define('TEMP_DIR', sys_get_temp_dir());
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        chdir(__DIR__);
        require LIBS_PATH.'/v2.5.3/vendor/autoload.php';
        break;
    // Production
    case 'clairemontferrond.tech':
        define('ENV', 'prod');
        define('PUBLIC_PATH', __DIR__);
        define('LIBS_PATH', '/home1/pinoypok/public_html/zf-libraries');
        define('TEMP_DIR', '/home1/pinoypok/tmp/');
        chdir(__DIR__);
        require LIBS_PATH.'/v2.5.3/vendor/autoload.php';
        break;
}

Zend\Mvc\Application::init(require 'config/application.config.php')->run();

