(function ($) {
    var ajaxLoader = $('.login-loader-holder');
    var error = 0;

    function hideErrors() {
        error = 0;
        $('#login-error-box').hide();
        $('#registration-error-box').hide();
        $('.errorMsg').remove();
        $('div, input, select').removeClass('errorBd');
    }

    function validateFields(form) {
        var toValidate = form + ' input,' + form + ' select';

        $(toValidate).each(function () {
            var value = $(this).val().trim();
            if (value.length == 0) {
                $(this).addClass('errorBd');
                error++;
            }
        });
    }

    function onLogin(e) {
        e.preventDefault();
        hideErrors();
        validateFields('#login-box');

        var username = $('.form-username').val();
        var password = $('.form-login-password').val();
        var csrf = $('#signinCsrf').val();

        var data = {
            username: username,
            password: password,
            signinCsrf: csrf,
        };

        if (error == 0) {
            $.ajax({
                type: "POST",
                url: basePath + 'signin/index',
                data: data,
                beforeSend: function () {
                    ajaxLoader.show();
                    hideErrors();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                complete: function () {
                    ajaxLoader.hide();
                },
                success: function (response) {
                    if (response.status == 0) {
                        $('#login-error-box')
                            .append('<p class="errorMsg">' + response.errors.signin + '</p>')
                            .show();
                    } else {
                        if (response.is_admin == 1) window.location.replace('choose-database');
                        else window.location.replace('profile');
                    }

                    // return false;
                    // if (resData.user) {
                    //     localStorage.setItem('active_tab', '#profile');
                    //     localStorage.setItem('dont_show_due_popup', '0');
                    //     localStorage.removeItem('cart');
                    //     localStorage.removeItem('customer');
                    //     localStorage.removeItem('current_customer');
                    //     if (resData.code == 1) window.location.replace('choose-db.php');
                    //     else {
                    //         if (resData.is_security) window.location.replace('dashboard.php?p=attendance');
                    //         else window.location.replace('dashboard.php?p=profile');
                    //     }
                    // }

                },
            });
        } else {
            $('#login-error-box').show();
            $('#login-error-box').append('<p class="errorMsg">* All Fields are required.</p>');
        }
    }

    function onRegister(e) {
        e.preventDefault();
        hideErrors();
        validateFields('#registration-box');

        var first_name = $('#form-first-name').val().trim();
        var last_name = $('#form-last-name').val().trim();
        var email = $('#form-email').val().trim();
        var role = $('#form-role').val();
        var password = $('#form-register-password').val().trim();
        var confirm_password = $('#form-confirm-password').val().trim();


        var data = {
            first_name: first_name,
            last_name: last_name,
            email: email,
            role: role,
            password: password,
            confirm_password: confirm_password,
        };


        if (error == 0) {
            $.ajax({
                type: "POST",
                url: 'functions/signup.php',
                data: data,
                beforeSend: function () {
                    hideErrors();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                complete: function () {
                },
                success: function (response) {
                    var resData = $.parseJSON(response);

                    if (resData.email) {
                        $('#registration-error-box').show();
                        $('#form-email').parent().addClass('errorBd');
                        $(resData.email).each(function (ind, obj) {
                            if (obj.invalidEmail) $('#registration-error-box').append('<p class="errorMsg">' + obj.invalidEmail + '</p>');
                            if (obj.emailExist) $('#registration-error-box').append('<p class="errorMsg">' + obj.emailExist + '</p>');
                        });
                    }

                    if (resData.password) {
                        $('#registration-error-box').show();
                        $('#form-register-password, #form-confirm-password').parent().addClass('errorBd');
                        $(resData.password).each(function (x, y) {
                            if (y.passwordNotMatch) $('#registration-error-box').append('<p class="errorMsg">' + y.passwordNotMatch + '</p>');
                            if (y.passwordLengthError) $('#registration-error-box').append('<p class="errorMsg">' + y.passwordLengthError + '</p>');
                            if (y.passwordNumericError) $('#registration-error-box').append('<p class="errorMsg">' + y.passwordNumericError + '</p>');
                            if (y.passwordCapitalAlphaError) $('#registration-error-box').append('<p class="errorMsg">' + y.passwordCapitalAlphaError + '</p>');
                            if (y.passwordSmallAlphaError) $('#registration-error-box').append('<p class="errorMsg">' + y.passwordSmallAlphaError + '</p>');
                        });
                    }

                    if (resData.newUser) window.location.replace('dashboard.php?p=profile');

                },
            });
        } else {
            $('#registration-error-box').show();
            $('#registration-error-box').append('<p class="errorMsg">* All Fields are required.</p>');
        }
    }

    function onForgetPassword() {
        $('#fp-message').hide();
        var error = 0;

        if (userId == 0 || userId == '') error++;
        if (fullName.length == 0) error++;

        if (error == 0) {
            $.ajax({
                type: "POST",
                url: 'functions/requestManager.php',
                data: {id: userId, fullName: fullName, reset: true},
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    var resData = $.parseJSON(response);
                    if (resData.sent) {
                        $('#fp-message').show();
                        $('#userId').val('');
                        $('#fullName').val('');

                        setTimeout(function () {
                            $('#fp-message').fadeOut(2500);
                        }, 3000);
                    }
                },
            });
        }
    }

    function showPassword() {
        var span = $('.hide-show span i');
        var x = $('.form-login-password');
        var type = x.attr('type');

        if (type == "password") {
            x.attr('type', 'text');
            span.removeClass('fa-eye');
            span.addClass('fa-eye-slash');
        } else {
            x.attr('type', 'password');
            span.removeClass('fa-eye-slash');
            span.addClass('fa-eye');
        }
    }

    function init() {
        if (typeof current_controller != "undefined" && current_controller != 'Signin') return;

        hideErrors();
        $('#registration-box').hide();
        $('#loginBtn').on('click', onLogin);
        $('#registerBtn').on('click', onRegister);
        $('#showPassword').click(showPassword);

        if (sendEmail) onForgetPassword();

    }

    $(document).ready(init);

}(jQuery));