(function ($) {
    /** declarations of variables */
    max_credit = typeof max_credit !== "undefined" ? max_credit : 0;
    var restockModal = $('#restockItemModal');
    var deleteModal = $('#deleteItemModal');
    var canteenAddEditForm = $('#canteen-item-form');
    var formSuccessBox = $('#cfSuccessBox');
    var tableSuccessBox = $('#ctSuccessBox');
    var productNameInput = $('#productName');
    var productStocksInput = $('#productStocks');
    var productPriceInput = $('#productPrice');
    var productQtyInput = $('#productQuantity');
    var productSubTotal = $('#productSubTotal');
    var resultContainer = $('.search-result');
    var resultList = $('#result-list');
    var userSearchContainer = $('.user-search-result');
    var userList = $('#user-result-list');
    var userInfoBox = $('.user-info-box');
    var customerNameInput = $('#buyerName');
    var customerId = $('#buyerId');
    var customerName = $('#buyerNameSpan');
    var customerWallet = $('#buyerBalanceSpan');
    var customerRewardPoint = $('#buyerRewardPointsSpan');
    var customerCash = $('#buyerCash');
    var confirmOrderBtn = $('#confirmCanteenOrder');
    var addToCartBtn = $('#buyCanteenItem');
    var isCash = $('#isCash');
    var isPostpaid = $('#isPostPaid');
    var isRewardUsed = $('#isRewardPointUsed');
    var pointsUsed = $('#pointsUsed');
    var errEmptyMsg = '<p class="errorMsg pull-right">* This is required.</p>';
    var errNotNumericMsg = '<p class="errorMsg">* Please input a number.</p>';
    var insufficientBalanceMsg = '<p class="errorMsg p-rel">* Insufficient E-wallet balance.</p>';
    var insufficientCreditMsg = '<p class="errorMsg p-rel">* You have exceeded the maximum credit allowed. (PHP ' + max_credit + ')</p>';
    var insufficientUserCreditMsg = '<p class="errorMsg p-rel">* You have exceeded your credit limit. Remaining balance: PHP ';
    var noCashMsg = '<p class="errorMsg">* Please input a valid amount.</p>';
    var notEnoughCashMsg = '<p class="errorMsg p-rel">* Insufficient cash amount.</p>';
    var noStockMsg = '<p class="errorMsg">* No Stock Available.</p>';
    var notEnoughStocks = '<p class="errorMsg">* Stocks not enough for the transaction.</p>';
    var noResultMsg = 'No result for "';
    var resultSet = [];
    var useResultSet = [];
    var error;
    var data;
    var total = 0;
    var userBalance = 0;
    var amount = 0;
    var oldQty = 0;
    var isGuestCustomer = 1;
    var pinMatched = 0;
    var remainingAllowedSpending = 0;
    var productTable;
    var productSalesTable;
    var productInventoryTable;
    var purchaseRecordsTable;
    var xhr;
    var xhr2;
    var xhr3;
    var xhr4;
    var xhr5;
    var xhr6;
    var xhr7;
    var xhr8;
    var xhr9;
    var canOrder = 1;
    var newQty = 0;
    var press_count = 0;
    var available_reward_amt = 0;
    var cart = JSON.parse(localStorage.getItem('cart'));

    function removeErrors() {
        error = 0;
        $('input, div, textarea').removeClass('errorBd');
        $('.errorMsg').remove();
        $('.errMsg.text-danger').remove();
    }

    function resetProductForm() {
        productNameInput
            .val('')
            .attr('data-id', '')
            .attr('data-mode', 'insert')
            .prop('readonly', false);
        productPriceInput.val('');
        productQtyInput.val('');
        productSubTotal.val('');
        productStocksInput.val('');
        addToCartBtn.prop('disabled', true);
    }

    function resetCheckboxOptions() {
        isPostpaid.prop('checked', false);
        isCash.prop('checked', false);
        customerCash.val('');
        isRewardUsed.prop('checked', false);
        pointsUsed.val('');
    }

    function resetBuyerForm() {
        $('.errorMsg').remove();
        $('input').removeClass('errorBd');
    }

    function resetInfoBox() {
        customerId.text('');
        customerName.text('');
        customerWallet.text('');
        userInfoBox.hide();
        customerNameInput.val('');
    }

    function onRestockModalHide() {
        restockModal.find('#newItemQuantity').val('');
        restockModal.find('#newItemSupplier').val('');
    }

    function readFile(file, callback) {
        var reader = new FileReader();

        reader.addEventListener('load', function () {
            var result = reader.result;
            $('#cItemImg').attr('src', result);
            $('#ProductImage').val(result);

            callback(result);
        });
        if (file) reader.readAsDataURL(file);
    }

    function onImageChange(e) {
        e.preventDefault();

        var img = $('#cItemImg');
        readFile(e.currentTarget.files[0], function (result) {
            img
                .attr('data-upload', 'true')
                .attr('data-fname', e.currentTarget.files[0]['name']);


            var data = {
                id: $('#productId').val(),
                src: $('#ProductImage').val(),
                file_name: e.currentTarget.files[0]['name'],
                change_picture: true,
            };

            if (xhr && xhr.readyState != 4) {
                xhr.abort();
            }

            xhr = $.ajax({
                type: "POST",
                url: 'functions/canteenManager.php',
                data: data,
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    var resData = $.parseJSON(response);
                    if (resData.status == 'success') {
                    }
                },
            });

        });
    }

    function onItemSave() {
        removeErrors();
        var required_fields = canteenAddEditForm.find('.req');
        var product_id = canteenAddEditForm.find('#cifProductId');
        var name = canteenAddEditForm.find('#cifProductName');
        var description = canteenAddEditForm.find('#cifProductDescription');
        var category = canteenAddEditForm.find('#cifProductCategory');
        var product_code = canteenAddEditForm.find('#cifProductCode');
        var price = canteenAddEditForm.find('#cifProductPrice');
        var image = $('#ProductImage').val();
        var facilities = canteenAddEditForm.find('#canteenFacilitiesSelect');
        var can_preorder = $('#canPreOrderItemsForm').prop('checked');


        var data = {
            id: product_id.val(),
            name: name.val(),
            description: description.val(),
            category: category.val(),
            picture: image,
            bar_code: product_code.val(),
            price: price.val(),
            facilities: facilities.val(),
            can_preorder: can_preorder,
        };

        if (xhr2 && xhr2.readyState != 4) {
            xhr2.abort();
        }

        xhr2 = $.ajax({
            type: "POST",
            data: {data: data},
            url: basePath + 'canteen/product-form/save',
            beforeSend: function () {
                // loader.show();
                removeErrors();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            success: function (response) {


                if (response.status == 0) {
                    for (var input in response.errors) {
                        var errorMsg = response.errors[input][Object.keys(response.errors[input]).pop()];

                        if (input == 'category' || input == 'facilities') {
                            $('select[name="' + input + '"')
                                .addClass('errorBd')
                                .closest('.form-group').append('<p class="text-danger">' + errorMsg + '</p>');
                        }

                        $('input[name="' + input + '"')
                            .addClass('errorBd')
                            .closest('.form-group').append('<p class="text-danger">' + errorMsg + '</p>');
                    }

                    notifyMe({
                        title: 'Error!',
                        msg: response.message,
                        type: 'danger',
                        delay: 5000,
                    });
                } else {
                    notifyMe({
                        title: 'Error!',
                        msg: response.message,
                        type: 'danger',
                        delay: 5000,
                    });

                    setTimeout(function () {
                        window.location.replace(basePath + 'canteen/products');
                    }, 3000);
                }

            },
            complete: function () {
                $('.cif-search-result').hide();
            }
        });

    }

    function onItemDelete() {
        var id = $(this).attr('data-id');

        deleteModal.on('click', function () {
            $('#canteenItemsTable').find('tr[data-id="' + id + '"]').remove();
            deleteModal.modal('hide');

            var data = {
                id: id,
                delete_item: true
            };

            if (xhr3 && xhr3.readyState != 4) {
                xhr3.abort();
            }

            xhr3 = $.ajax({
                type: "POST",
                data: data,
                url: 'functions/canteenManager.php',
                beforeSend: function () {
                    // loader.show();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    var resData = $.parseJSON(response);
                    if (resData.status != null && resData.status == 'success') {
                        tableSuccessBox.find('.msg-span').text('Item Deleted.');
                        tableSuccessBox.show();
                        setTimeout(function () {
                            tableSuccessBox.fadeOut(1000)
                        }, 1500);
                    }
                }
            });

        });
    }

    function onItemRestock() {
        var product_name = $(this).closest('tr').find('#productName').text();
        var product_id = $(this).closest('tr').attr('data-id');
        // var product_stock = $(this).closest('tr').find('#productStock').text();
        var facs = $(this).closest('tr').find('li.fac-id');
        restockModal.find('#newItemFac').find('option').not(':first').remove();

        if (facs.length > 0) {
            facs.each(function () {
                restockModal.find('#newItemFac')
                    .append('<option value="' + $(this).attr('data-id') + '">' + $(this).find('span.fac-name').text() + '</option>');
            });
        }

        restockModal.find('.item-name').text(product_name);

        $('#saveStock').off('click').on('click', function () {
            var qty = restockModal.find('#newItemQuantity').val();
            var supplier = restockModal.find('#newItemSupplier').val();
            var facility = restockModal.find('#newItemFac').val();
            var err = 0;

            // Remove errors
            $('.errorMsg').remove();
            $('input, select').removeClass('errorBd');

            if (!jmrValidator(qty).isNumber()) {
                restockModal.find('#newItemQuantity')
                    .addClass('errorBd')
                    .after(errNotNumericMsg);
                err++;
            }

            if (facility == '') {
                restockModal.find('#newItemFac')
                    .addClass('errorBd')
                    .after(errEmptyMsg);
                err++;
            }

            if (err == 0) {

                var data = {
                    product_id: product_id,
                    quantity: qty,
                    supplier: supplier,
                    // currentCount: parseInt(product_stock),
                    facility: facility,
                    restock_item: true,
                };

                if (xhr4 && xhr4.readyState != 4) xhr4.abort();
                xhr4 = $.ajax({
                    type: "POST",
                    data: data,
                    url: 'functions/canteenManager.php',
                    beforeSend: function () {
                        // loader.show();
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    success: function (response) {
                        var resData = $.parseJSON(response);
                        if (resData.status != null && resData.status == 'success') {
                            restockModal.modal('hide');
                            $('#canteenItemsTable tbody')
                                .find('tr[data-id="' + product_id + '"]')
                                .find('li.fac-id[data-id="' + resData.fac_id + '"]')
                                .find('.fac-stock').text(resData.fac_stock + ' pc(s)');
                            tableSuccessBox.find('.msg-span').text('Stocks added.');
                            tableSuccessBox.show();
                            setTimeout(function () {
                                tableSuccessBox.fadeOut(1000)
                            }, 1500);
                        }
                    }
                });
            }

        });

    }

    function listCart() {
        var cart = localStorage.getItem('cart');

        if (cart != null) {
            $.each(JSON.parse(cart), function (i, e) {
                $('#canteenCartTable tbody').append('<tr class="cartItem" data-id="' + e.id + '">' +
                    '<td class="p-name">' + e.name + '</td>' +
                    '<td class="p-qty">' + e.qty + '</td>' +
                    '<td class="p-price">' + e.price + '</td>' +
                    '<td class="p-sub-total">' + e.sub_total + '</td>' +
                    '<td>' +
                    '<i class="fa fa-pencil text-warning editItem mr-10"></i> |' +
                    '<i class="fa fa-times text-danger removeItem ml-10"></i> ' +
                    '</td>' +
                    '</tr>');
            });

            $('.removeItem, .editItem').css('cursor', 'pointer');
            $('.removeItem').off('click').on('click', removeItemFromCart);
            $('.editItem').off('click').on('click', editItemOnCart);
            $('#noItem').hide();

            getCartTotal();
            confirmOrderBtn.prop('disabled', false);

            if (!JSON.parse(cart).length) {
                $('#noItem').show();
                confirmOrderBtn.prop('disabled', true);
            }
        }
    }

    function isCashPayment() {
        var isChecked = $(this).prop('checked');
        resetBuyerForm();

        if (isChecked) {
            customerCash.prop('disabled', false);
            addToCartBtn.prop('disabled', false);
            productNameInput.prop('disabled', false)
            isPostpaid
                .prop('checked', false)
                .prop('disabled', true);
        } else {
            customerCash.removeClass('errorBd');
            customerCash.prop('disabled', true);
            addToCartBtn.prop('disabled', true);
            isPostpaid.prop('disabled', false);
            if (remainingAllowedSpending == 0) productNameInput.prop('disabled', true);
        }

        onQuantityChange();
    }

    function isPostpaidPayment() {
        var isChecked = $(this).prop('checked');
        resetBuyerForm();

        if (isChecked) {
            isCash.prop('checked', false);
            customerCash.prop('disabled', true);
            addToCartBtn.prop('disabled', false);
        } else {
            addToCartBtn.prop('disabled', true);
            customerCash.prop('disabled', false);
        }

        onQuantityChange();
    }

    function noProduct() {
        resultContainer.hide();
        userInfoBox.find('p.errorMsg').remove();
        productQtyInput.val(0);
        productSubTotal.val('');
        productPriceInput.val('');

        addToCartBtn.prop('disabled', true);
        removeErrors();
    }

    function onProductSearch() {
        var input = $(this);
        var result;
        resultList.html('');
        resultSet = [];

        if (input.val.length < 3) noProduct();

        input.autocomplete({
            minLength: 3,
            source: function (request, response) {
                var term = $.trim(request.term);
                data = {
                    facility: localStorage.getItem('facility_id'),
                    keyword: term,
                    list_products: true,
                };

                if (xhr5 && xhr5.readyState != 4) {
                    xhr5.abort();
                }

                xhr5 = $.ajax({
                    url: 'functions/canteenManager.php',
                    type: 'POST',
                    data: data,
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    beforeSend: function () {
                        input.addClass('loading');
                        resultContainer.hide();
                    },
                    success: function (data) {
                        result = $.parseJSON(data);
                        resultList.html('');

                        if (!result.length) {
                            resultList.append('<li>' + noResultMsg + input.val() + '"</li>');
                            resultList.css('pointerEvents', 'none');
                        } else {
                            $.each(result, function (key, obj) {
                                resultSet.push(obj);
                                resultList.css({'pointerEvents': 'auto', 'cursor': 'pointer'});
                                resultList.append('<li class="i-result" data-id="' + obj.id + '" data-key="' + key + '">' + obj.name + '</li>');
                            });

                            $('.i-result').on('click', onProductResultClick);
                        }
                    },
                    complete: function () {
                        input.removeClass('loading');
                        resultContainer.show();

                        if (result.length == 1) onProductResultClick();
                    },
                });
            }
        });
    }

    function onProductResultClick() {
        resultContainer.hide();

        var ind = $(this).attr('data-key');
        if (typeof ind == 'undefined') ind = 0;
        var stocks = parseInt(resultSet[ind]['stock_count']);
        var qty = newQty == 0 ? 1 : newQty;

        productNameInput.val(resultSet[ind]['name']);
        productNameInput.attr('data-id', resultSet[ind]['id']);
        productStocksInput.val(stocks);
        productPriceInput.val(resultSet[ind]['price']);
        productQtyInput.val(qty);
        onQuantityChange();

        if (productNameInput.val().length > 0) {
            if (stocks == 0) {
                productStocksInput
                    .addClass('errorBd')
                    .after(noStockMsg);
                addToCartBtn.prop('disabled', true);
            } else {
                addToCart();
            }
        }
    }

    function onQuantityChange() {
        var total = parseFloat($('.cart-total').text()).toFixed(2);
        var balance = parseFloat(customerWallet.text()).toFixed(2);
        var id = productNameInput.attr('data-id');
        var mode = productNameInput.attr('data-mode');
        var stocks = productStocksInput.val();
        var qty = productQtyInput.val();
        var price = productPriceInput.val();
        var is_cash = isCash.prop('checked');
        var is_postpaid = isPostpaid.prop('checked');
        var postpaid_balance = customerWallet.attr('data-postpaid');
        var remaining_pp_balance = parseFloat(max_credit) - parseFloat(postpaid_balance);
        var result = 0;
        var tot = 0;
        newQty = qty;

        // set remaining postpaid balance to 0
        if (parseFloat(postpaid_balance) >= parseFloat(max_credit)) remaining_pp_balance = 0;

        $('#buyerForm').find('.errorMsg').remove();
        $('#warning-box').hide();
        $('#warningMsg').text('');

        if (productQtyInput.val() > 0) {
            result = parseFloat(price) * parseInt(qty);
            addToCartBtn.prop('disabled', false);
        } else {
            addToCartBtn.prop('disabled', true);
        }

        if (parseInt(stocks) > 0) {
            if (parseInt(qty) > parseInt(stocks)) {
                productStocksInput
                    .addClass('errorBd')
                    .after(notEnoughStocks);
                addToCartBtn.prop('disabled', true);
                canOrder = 0;
            } else {
                productStocksInput
                    .removeClass('errorBd')
                    .parent().find('.errorMsg').remove();
                addToCartBtn.prop('disabled', false);
            }
        }

        if (mode == 'update') {
            var toCount = $('.cartItem:not([data-id="' + id + '"])');
            $.each(toCount, function () {
                tot = parseFloat(tot) + parseFloat($(this).find('.p-sub-total').text());
            });

            total = parseFloat(tot).toFixed(2);
        }

        amount = parseFloat(total) + parseFloat(result);

        if (!is_cash) {
            if (amount > remainingAllowedSpending) {
                addToCartBtn.prop('disabled', true);
                var totalSpending = parseFloat(customerWallet.attr('data-ds') + amount).toFixed(2);
                $('#warningMsg').text('Oops! Seems like ' + customerName.text() + ' has reached his/her spending limit of PHP ' + customerWallet.attr('data-ms') + '. Total spendings for this day: ' + totalSpending + '. Including the item on the cart. Purchasing items using card is not allowed anymore.');
                if (!isGuestCustomer) $('#warning-box').show();
                canOrder = 0;
            } else {
                addToCartBtn.prop('disabled', false);
                $('#warning-box').hide();
            }
        } else {
            if (amount > customerCash.val()) {
                customerCash.after(notEnoughCashMsg);
                customerCash.addClass('errorBd');
                addToCartBtn.prop('disabled', true);
                canOrder = 0;
            } else {
                customerCash.removeClass('errorBd');
                addToCartBtn.prop('disabled', false);
                canOrder = 1;
            }
        }

        if (!is_cash && !is_postpaid) {
            if (amount > balance) {
                addToCartBtn.prop('disabled', true);
                $('#uBox').after(insufficientBalanceMsg);
                canOrder = 0;
            } else {
                addToCartBtn.prop('disabled', false);
                canOrder = 1;
            }
        }

        if (is_postpaid) {
            isPostpaid.removeClass('errorBd');
            addToCartBtn.prop('disabled', false);
            canOrder = 1;

            if (amount > remaining_pp_balance && amount < max_credit) {
                addToCartBtn.prop('disabled', true);
                isPostpaid.parent().append(insufficientUserCreditMsg + remaining_pp_balance + '</p>');
                canOrder = 0;
            }

            if (amount > max_credit) {
                addToCartBtn.prop('disabled', true);
                isPostpaid.parent().append(insufficientCreditMsg);
                canOrder = 0;
            }
        }

        if (canOrder) confirmOrderBtn.prop('disabled', false);
        else confirmOrderBtn.prop('disabled', true);

        productSubTotal.val(result.toFixed(2));
    }

    function addToCart() {
        if (cart == null) cart = [];

        if (productQtyInput.val() > 0 && typeof productNameInput.attr('data-id') !== 'undefined') {
            var mode = productNameInput.attr('data-mode');
            var item = {
                id: productNameInput.attr('data-id'),
                name: productNameInput.val(),
                qty: productQtyInput.val(),
                price: productPriceInput.val(),
                sub_total: productSubTotal.val(),
                stocks: productStocksInput.val(),
            };

            if (mode == 'update') {
                $.each(cart, function (i, e) {
                    if (typeof e !== 'undefined') {
                        if (e.id == item.id) cart.splice(i, 1);
                    }
                });

                cart.push(item);
                localStorage.setItem('cart', JSON.stringify(cart));

                var row = $('#canteenCartTable tbody').find('tr[data-id="' + item.id + '"]');
                row.find('.p-name').text(item.name);
                row.find('.p-qty').text(item.qty);
                row.find('.p-price').text(item.price);
                row.find('.p-sub-total').text(item.sub_total);

            } else {

                //if the item is already in the cart edit the quantity of item instead of inserting new row
                $.each(cart, function (i, e) {
                    if (typeof e !== 'undefined') {
                        if (e.id == item.id) {
                            item.qty = parseInt(e.qty) + parseInt(item.qty);
                            item.sub_total = parseFloat(parseFloat(item.price) * parseInt(item.qty)).toFixed(2);

                            $('.cartItem[data-id="' + e.id + '"]').remove();
                            cart.splice(i, 1);
                        }
                    }
                });

                cart.push(item);
                localStorage.setItem('cart', JSON.stringify(cart));

                $('#noItem').hide();
                $('#canteenCartTable').append('<tr class="cartItem" data-id="' + item.id + '">' +
                    '<td class="p-name">' + item.name + '</td>' +
                    '<td class="p-qty" data-stocks="' + item.stocks + '">' + item.qty + '</td>' +
                    '<td class="p-price">' + item.price + '</td>' +
                    '<td class="p-sub-total">' + item.sub_total + '</td>' +
                    '<td>' +
                    '<i class="fa fa-pencil text-warning editItem mr-10"></i> | ' +
                    '<i class="fa fa-times text-danger removeItem ml-10"></i> ' +
                    '</td>' +
                    '</tr>');
            }

            $('.removeItem, .editItem').css('cursor', 'pointer');
            $('.removeItem').off('click').on('click', removeItemFromCart);
            $('.editItem').off('click').on('click', editItemOnCart);

            getCartTotal(0);
            resetProductForm();
            confirmOrderBtn.prop('disabled', false);
            canOrder = 1;
            newQty = 0;
        }
        cart = JSON.parse(localStorage.getItem('cart'));
    }

    function getCartTotal() {
        var cart = localStorage.getItem('cart');
        var total = 0;
        var sub_total = 0;

        if (cart != null) {
            $.each(JSON.parse(cart), function (i, e) {
                sub_total += parseFloat(e.sub_total);
            });
            total = sub_total.toFixed(2);
        }

        $('.cart-total').text(total);
    }

    function removeItemFromCart() {
        var id = $(this).closest('tr').attr('data-id');
        deleteModal.modal();


        $('#deleteItemConfirm').on('click', function () {
            $.each(cart, function (i, e) {
                if (typeof e !== 'undefined') {
                    if (e.id == id) cart.splice(i, 1);
                }
            });

            localStorage.setItem('cart', JSON.stringify(cart));
            $('#canteenCartTable').find('tr[data-id="' + id + '"]').remove();
            deleteModal.modal('hide');

            if (!cart.length) {
                $('#noItem').show();
                confirmOrderBtn.prop('disabled', true);
            }
            getCartTotal();

            cart = JSON.parse(localStorage.getItem('cart'));
        });

    }

    function editItemOnCart() {
        var list = $(this).closest('tr');
        var id = list.attr('data-id');
        oldQty = list.find('.p-qty').text();

        productNameInput
            .attr('data-index', list.index() - 1)
            .attr('data-id', id)
            .attr('data-mode', 'update')
            .prop('readonly', true)
            .val(list.find('.p-name').text());
        productStocksInput.val(list.find('.p-qty').attr('data-stocks'));
        productPriceInput.val(list.find('.p-price').text());
        productQtyInput.val(oldQty);
        productSubTotal.val(parseFloat(list.find('.p-sub-total').text()).toFixed(2));
        addToCartBtn.prop('disabled', false);
    }

    function verifyPin() {
        var pin = $('#ewp');
        removeErrors();

        if (!pin.val().length) {
            pin
                .addClass('errorBd')
                .after('<p class="errorMsg">* Please enter the pin.</p>');
        } else {
            var data = {
                e_pin: pin.val(),
                user_id: parseInt(customerId.text()),
                verify_e_pin: true,
            };

            if (xhr6 && xhr6.readyState != 4) {
                xhr6.abort();
            }

            xhr6 = $.ajax({
                type: "POST",
                data: data,
                url: 'functions/profileManager.php',
                beforeSend: function () {
                    pin.addClass('loading');
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    var resData = $.parseJSON(response);
                    if (resData != null) {
                        if (resData.pin_matched) {
                            pinMatched = 1;
                            $('#ePinModal').modal('hide');
                            confirmOrderBtn.trigger('click');
                        } else {
                            pin
                                .addClass('errorBd')
                                .after('<p class="errorMsg">* Incorrect Pin.</p>');
                        }
                    }
                },
                complete: function () {
                    pin.removeClass('loading');
                }
            });
        }
    }

    function confirmOrder() {
        var _this = $(this);
        var items = JSON.parse(localStorage.getItem('cart'));
        var user_id = isGuestCustomer ? 0 : parseInt(customerId.text());
        var cashInput = customerCash.val();
        var wallet = $('#buyerBalanceSpan').text();
        var is_cash = isGuestCustomer ? 'true' : isCash.prop('checked');
        var is_postpaid = isGuestCustomer ? 'false' : isPostpaid.prop('checked');
        var total = parseFloat($('.cart-total').text());
        var hasPin = parseInt(customerId.attr('data-pin'));
        var rowCount = $('#canteenCartTable tbody tr').not('#noItem').length;
        var reward_amt = 0;
        var error = 0;
        var can_use_reward = 1;
        $('.errorMsg, .errMsg.text-danger').remove();
        customerCash.removeClass('errorBd');
        press_count = 0;

        if (rowCount == 0) {
            confirmOrderBtn.after('<h4 class="errMsg text-danger">No items to checkout!</h4>');
            return false;
        }

        if (isGuestCustomer) {
            can_use_reward = 0;
            if (cashInput.length == 0) {
                customerCash
                    .addClass('errorBd')
                    .after(noCashMsg);
                error++;
            } else {
                if (!jmrValidator(cashInput).isNumber()) {
                    customerCash
                        .addClass('errorBd')
                        .after(noCashMsg);
                    error++;
                }

                if (parseFloat(cashInput) < total) {
                    customerCash
                        .addClass('errorBd')
                        .after(notEnoughCashMsg);
                    error++;
                }
            }
        }

        if (!is_postpaid && !is_cash) {
            if (total > parseFloat(wallet)) {
                $('#uBox').before(insufficientBalanceMsg);
                error++;
            }
        }

        if (can_use_reward) {
            if (typeof isRewardUsed != "undefined" && isRewardUsed.prop('checked')) {
                reward_amt = pointsUsed.val();
                total = total - reward_amt;
            }
        }

        if (error == 0) {
            var data = {
                user_id: user_id,
                current_user: currentUser,
                cash: cashInput,
                is_cash: is_cash,
                is_postpaid: is_postpaid,
                is_preorder: 0,
                items: items,
                total_amount: total,
                facility: localStorage.getItem('facility_id'),
                reward_amount: reward_amt,
                save_cart: true
            };

            if (!pinMatched && hasPin) $('#ePinModal').modal();
            else pinMatched = 1;

            if (pinMatched) {
                if (xhr7 && xhr7.readyState != 4) {
                    xhr7.abort();
                }

                xhr7 = $.ajax({
                    type: "POST",
                    data: data,
                    url: 'functions/canteenManager.php',
                    beforeSend: function () {
                        // loader.show();
                        $('.processLoaderContainer').show();
                        _this.prop('disabled', true);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    success: function (response) {
                        var resData = $.parseJSON(response);

                        if (resData.status != null && resData.status == 'success') {

                            var or = resData.order_number;
                            var receipt_data = localStorage.getItem('receipt');

                            if (receipt_data != null) receipt_data = JSON.parse(receipt_data);
                            else receipt_data = {};

                            receipt_data[or] = {
                                user: resData.user,
                                sold_by: resData.sold_by,
                                date_sold: resData.date_sold,
                                order_number: resData.order_number,
                                reward_amt: reward_amt,
                                items: items,
                            };

                            cart = [];
                            localStorage.setItem('receipt', JSON.stringify(receipt_data));
                            localStorage.setItem('cart', cart);
                            localStorage.removeItem('customer');

                            $('.change-amt').text(parseFloat(resData.change).toFixed(2));

                            $('#cpSuccessBox').find('.order_number').text(resData.order_number);
                            $('#cpSuccessBox').show();
                            $('.cartItem').remove();
                            $('.cart-total').text(0);
                            $('#noItem').show();
                            resetProductForm();
                            resetCheckboxOptions();
                            resetInfoBox();

                            // print window
                            $('.print-receipt').attr('href', 'receipt.php?sinum=' + resData.order_number);


                            //show success message
                            $('html, body').animate({scrollTop: $('#cpSuccessBox').offset().top - 110}, 800);

                        }
                    },
                    complete: function () {
                        $('.processLoaderContainer').hide();
                    }
                });
            }
        }
    }

    function onUserSearch() {
        var input = $(this);
        var val = input.val().trim();
        var buyerName = customerNameInput;
        var result;
        useResultSet = [];
        isGuestCustomer = 1;

        input.attr('data-id', '');
        userList.html('');
        buyerName.attr('placeholder', 'Searching for..');

        if (val.length < 3) {
            isGuestCustomer = 1;
            userInfoBox.hide();
            userSearchContainer.hide();
            isPostpaid.prop('disabled', true);
            $('.errorMsg').remove();
            localStorage.removeItem('customer');
        }

        input.autocomplete({
            minLength: 3,
            source: function (request, response) {
                var term = $.trim(request.term);
                data = {
                    keyword: term,
                    user_search: true,
                };

                if (xhr8 && xhr8.readyState != 4) {
                    xhr8.abort();
                }

                xhr8 = $.ajax({
                    type: "POST",
                    data: data,
                    url: 'functions/canteenManager.php',
                    beforeSend: function () {
                        input.addClass('.loading');
                        userSearchContainer.hide();
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    success: function (response) {
                        result = $.parseJSON(response);

                        if (result.status != null && result.status == 404) {
                            userList.html('<li>' + noResultMsg + input.val() + '"</li>');
                            userList.css('pointerEvents', 'none');
                        } else {
                            if (result.data != null) {
                                isGuestCustomer = 0;
                                $.each(result.data, function (i, e) {
                                    e.cid = data.keyword;
                                    useResultSet.push(e);
                                    userList.append('<li class="u-result" data-key="' + i + '" data-id="' + e.user_id + '" data-pin="' + e.has_e_wallet_pin + '">' + e.user_name + '</li>');
                                });
                            }
                            userList.css({'pointerEvents': 'auto', 'cursor': 'pointer'});
                        }

                        userSearchContainer.show();
                        $('.u-result').on('click', onUserResultClick);
                    },
                    complete: function () {
                        input.removeClass('.loading');
                        if (useResultSet.length == 1) onUserResultClick();
                    },
                });
            }
        });
    }

    function onUserResultClick() {
        press_count = 0;
        var ind = $(this).attr('data-key');
        if (typeof ind == 'undefined') ind = 0;

        var selected = useResultSet[ind];
        if (selected != null) {
            var dailySpending = selected['daily_spending'] == null ? 0 : parseFloat(selected['daily_spending']);
            var maxSpending = parseFloat(selected['max_daily_spending']).toFixed(2);
            isGuestCustomer = 0;
            localStorage.setItem('customer', JSON.stringify(selected));

            customerNameInput.val(selected['user_name']);
            userBalance = parseFloat(selected['wallet_balance']).toFixed(2);
            customerId.text(selected['user_id']);
            customerId.attr('data-pin', selected['has_e_wallet_pin']);
            customerName.text(selected['user_name']);
            customerWallet.text(userBalance);
            customerWallet.attr('data-postpaid', selected['postpaid_balance']);
            customerWallet.attr('data-ms', maxSpending);
            customerWallet.attr('data-ds', dailySpending);
            userSearchContainer.hide();
            userInfoBox.show();
            $('#warning-box').hide();

            isPostpaid.prop('disabled', false);

            if (dailySpending >= maxSpending) {
                productNameInput.prop('disabled', true);
                $('#warningMsg').text('Oops! Seems like ' + selected['user_name'] + ' has reached his/her spending limit of PHP ' + maxSpending + '. Total spendings for this day: ' + dailySpending + '. Purchasing items using card is not allowed anymore.');
                $('#warning-box').show();
            } else {
                productNameInput.prop('disabled', false);
            }

            remainingAllowedSpending = maxSpending - dailySpending;
            var percentage = selected['max_daily_spending'] * .20;
            if (remainingAllowedSpending == percentage) {
                $('#warningMsg').text('Heads up! Seems like ' + selected['user_name'] + ' is almost on his/her spending limit of PHP ' + maxSpending + '. Total spendings for this day: ' + dailySpending + '. Purchasing items using card will be limited to remaining of spending limit.');
                $('#warning-box').show();
            }

            // rewards
            if (is_reward_system_enabled) {
                var reward_points = selected['reward_points'];
                $('.reward-holder').show();
                customerRewardPoint.text(reward_points);

                if (reward_points > 0) {
                    available_reward_amt = reward_points / conversion_points;
                    pointsUsed.val(parseFloat(available_reward_amt).toFixed(2));
                }
            }
        }
    }

    function getUser() {
        var user = JSON.parse(localStorage.getItem('customer'));
        useResultSet.push(user);
        onUserResultClick();
    }

    function onDateChange(e) {
        var value = $(this).val();
        if (value.length > 0) {
            $('#filterForm').submit();
        }
    }

    function onCheckProductDuplicate() {
        var input = $(this);
        var result;
        var resultContainer = $('.cif-search-result');
        var resultList = $('#cif-result-list');

        if (input.val().length < 3) resultContainer.hide();

        input.autocomplete({
            minLength: 3,
            source: function (request, response) {
                var term = $.trim(request.term);
                data = {
                    keyword: term,
                    src: 'purchase-form',
                    list_products: true,
                };

                if (xhr9 && xhr9.readyState != 4) {
                    xhr9.abort();
                }

                xhr9 = $.ajax({
                    url: 'functions/canteenManager.php',
                    type: 'POST',
                    data: data,
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    beforeSend: function () {
                        input.addClass('loading');
                        resultContainer.hide();
                        resultList.html('');
                    },
                    success: function (data) {
                        result = $.parseJSON(data);

                        if (result.length > 0) {
                            resultList.append('<li class="it">* Existing product on inventory:</li>');
                            $.each(result, function (key, obj) {
                                resultList.append('<li>' + obj.name + '</li>');
                            });

                            resultContainer.show();
                        }
                    },
                    complete: function () {
                        input.removeClass('loading');
                    },
                });
            }
        });
    }

    /** facility functions **/
    function chooseFacility() {
        var fac_id = $('#chooseFacilitySelect').val();
        var fac_name = $('#chooseFacilitySelect option:selected').text();

        $('#chooseFacilitySelect').removeClass('errorBd');
        $('#chooseFacilityModal').find('.text-danger').remove();

        if (fac_id == '') {
            $('#chooseFacilitySelect')
                .addClass('errorBd')
                .after('<p class="text-danger">* Choose a facility to proceed!</p>');
        } else {
            localStorage.setItem('facility_id', fac_id);
            localStorage.setItem('facility_name', fac_name);
            $('.selectedCanteen strong').text(fac_name);
            $('#chooseFacilityModal').modal('hide');
        }
    }

    function onOpenFacilityModal(e) {
        e.preventDefault();
        var rowCount = $('.cartItem').length;
        $('p.text-danger').remove();

        if (rowCount > 0)
            $(this).after('<p class="text-danger">Oops! Cannot change facility while there are items on the cart.</p>');
        else $('#chooseFacilityModal').modal();
    }

    function onRewardUseChange() {
        var _val = $(this).val();
        if (is_reward_system_enabled) {
            if (_val > available_reward_amt) {
                pointsUsed
                    .addClass('errorBd')
                    .after('<p class="errorMsg">Not enough point(s) to use.</p>');
            } else {
                pointsUsed
                    .removeClass('errorBd')
                    .parent().find('.errorMsg').remove();
            }
        }
    }

    function onProductStatusChange(e) {
        e.preventDefault();
        var button = $(e.currentTarget);
        var id = button.closest('tr').attr('data-id');
        var status = button.attr('data-status');
        var newStatus, newClass, oldClass, newIcon;
        var label;

        if (status == 0) {
            newStatus = 1;
            newClass = 'btn-warning';
            oldClass = 'btn-danger';
            newIcon = 'fa-check';
            label = 'ENABLE';

        } else {
            newStatus = 0;
            newClass = 'btn-danger';
            oldClass = 'btn-warning';
            newIcon = 'fa-ban';
            label = 'DISABLE'
        }

        var data = {
            change_product_status: true,
            id: id,
            status: newStatus,
        };
        if (id) {
            $.ajax({
                type: "POST",
                url: 'functions/canteenManager.php',
                data: data,
                beforeSend: function () {
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                complete: function () {
                },
                success: function (response) {
                    var resData = $.parseJSON(response);
                    if (resData.status == 'success') {
                        button.text('');
                        button.prepend('<i class="fa ' + newIcon + '"></i> ' + label);
                        button.attr('data-status', newStatus);
                        button.removeClass(oldClass).addClass(newClass);

                        tableSuccessBox.find('.msg-span').text('Item Status Changed.');
                        tableSuccessBox.show();
                        setTimeout(function () {
                            tableSuccessBox.fadeOut(1000)
                        }, 1500);

                    }
                },
            });
        }
    }

    function init() {
        if (typeof current_controller != "undefined" && current_controller != 'Canteen') return;
        listCart();
        getUser();
        $('#saveCanteenItem').on('click', onItemSave);
        $('.del-i-btn').on('click', onItemDelete);
        $('.restock-i-btn').on('click', onItemRestock);
        $('.btn-disable-item').on('click', onProductStatusChange);
        $('#addCanteenItemImg').on('click', function (e) {
            e.preventDefault();
            $('#uploadProductImage').trigger('click');
        });
        $('#uploadProductImage').on('change', onImageChange);
        customerNameInput.on('keyup', onUserSearch);
        productNameInput.on('keyup', onProductSearch);
        productQtyInput.on('keyup', onQuantityChange);
        addToCartBtn.on('click', addToCart);
        confirmOrderBtn.on('click', confirmOrder);
        $('#buyerForm').on('submit', function () {
            return false;
        });
        $('#dateValue').on('change', onDateChange);
        restockModal.on('hidden.bs.modal', onRestockModalHide);
        isCash.on('click', isCashPayment);
        isPostpaid.on('click', isPostpaidPayment);
        customerCash.on('keyup', onQuantityChange);
        pointsUsed.on('change, keyup', onRewardUseChange);

        $('#cifProductName').on('keyup', onCheckProductDuplicate);
        $('#submitPinBtn').on('click', verifyPin);
        $('#ePinModal').on('hidden.bs.modal', function () {
            $('#ewp').val('');
        });

        /** facility related js**/
        $('#chooseFacilityBtn').on('click', chooseFacility);
        $('#chooseFacilityLink').on('click', onOpenFacilityModal);

        /** download button scripts **/
        $('#dl-canteen-report-btn').click(function (e) {
            e.preventDefault();
            var page = $(this).attr('data-page');
            var table = $('#canteenItemsTable');
            generateReport(page, table, productTable);
        });

        $('#dl-canteen-inventory-report-btn').click(function (e) {
            e.preventDefault();
            var page = $(this).attr('data-page');
            var table = $('#canteenInventoryTable');
            generateReport(page, table, productInventoryTable);
        });

        $('#dl-canteen-item-sold-report-btn').click(function (e) {
            e.preventDefault();
            var page = $(this).attr('data-page');
            var table = $('#canteenSoldItemsTable');
            generateReport(page, table, purchaseRecordsTable);
        });

        $('#dl-canteen-sales-report-btn').click(function (e) {
            e.preventDefault();
            var page = $(this).attr('data-page');
            var table = $('#canteenSalesTable');
            generateReport(page, table, productSalesTable);
        });

        if (typeof range !== 'undefined') {
            $('#dateValue').val(range);
            $('#daterange-btn span').text(range);

            if (range == '') $('#daterange-btn span').text('Today');
        }

        if (action == "BaseModule/Controller/Canteen/purchase-form") {
            productNameInput.focus();

            // attached keypress(enter) to purchase form confirm order
            $('body').off('keypress').on('keypress', function (e) {
                var key = e.which;

                if (canOrder) {
                    if (key == 13) {
                        if (press_count == 0) confirmOrder();
                    } else press_count++;
                }
            });
        }

        productTable = $('#canteenItemsTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "columns": [
                null,
                null,
                null,
                null,
                null,
                null,
                {"orderable": false},
            ],
            "order": [[0, "asc"]],
            "language": {
                "emptyTable": "No Results Found."
            },
            "initComplete": function (settings, json) {
                // show table and hide loader
                $('.div-loader').hide();
                $('div.table-responsive').show();
            }
        });

        productInventoryTable = $('#canteenInventoryTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [],
            "language": {
                "emptyTable": "No Results Found."
            },
            "initComplete": function (settings, json) {
                // show table and hide loader
                $('.div-loader').hide();
                $('div.table-responsive').show();
            }
        });

        purchaseRecordsTable = $('#canteenSoldItemsTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [],
            "language": {
                "emptyTable": "No Results Found."
            },
            "initComplete": function (settings, json) {
                // show table and hide loader
                $('.div-loader').hide();
                $('div.table-responsive').show();
            }
        });

        productSalesTable = $('#canteenSalesTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [],
            "language": {
                "emptyTable": "No Results Found."
            },
            "initComplete": function (settings, json) {
                // show table and hide loader
                $('.div-loader').hide();
                $('div.table-responsive').show();
            }
        });

        var hasFacility = localStorage.getItem('facility_id');
        if (hasFacility == null) $('#chooseFacilityModal').modal();
        else $('.selectedCanteen strong').text(localStorage.getItem('facility_name'));

        /** filter **/
        $('#facilitySelect').change(function () {
            $('#filterForm').submit();
        });
    }

    $(document).ready(init);
}(jQuery));