(function ($) {
    var errorBox = $('#error-box');
    var preloader = $('#preloader');
    var error = 0;
    var err1;
    var err2;
    var err3;
    var count = 0;
    var smsXhr;

    function hideErrors() {
        error = 0;
        err1 = '';
        err2 = '';
        errorBox.find('p').remove();
        errorBox.hide();
        $('input, textarea, select').removeClass('errorBd is-invalid');
    }

    function validateFields() {
        hideErrors();
        $('.req').each(function () {
            var $this = $(this);
            if (!$this.val().length) {
                $this.addClass('errorBd is-invalid');
                err1 = '<p class="mb-0">* Fill the required fields</p>';
                error++;
            }
        });

        var checked = $('.cb:checked').length;
        if (checked == 0) {
            $('.cb').addClass('errorBd is-invalid');
            err2 = '<p class="mb-0">* Choose at least one announcement mode</p>';
            error++;
        }

        if (parseInt(count) > 300) {
            $('#body').addClass('errorBd is-invalid');
            err3 = '<p class="mb-0">* You have reached the maximum character limit. Please make your message shorter.</p>';
            error++;
        }

    }

    function onSend(e) {
        e.preventDefault();
        validateFields();
        if (error > 0) {
            errorBox
                .append(err1)
                .append(err2)
                .append(err3);
            errorBox.show();
        } else {
            var data = {
                target_audience: $('#target-audience').val(),
                subject: $('#subject').val().trim(),
                body: $('#body').val().trim(),
                is_sms: $('#cb-sms').prop('checked'),
                is_email: $('#cb-email').prop('checked'),
            };

            preloader.show();
            $('#sendAnnouncement').hide();
            $.ajax({
                type: "POST",
                url: basePath + 'announcement/index/send',
                data: data,
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    if (response.status == 1) {
                        notifyMe({
                            title: 'Success!',
                            msg: response.msg,
                            type: 'success',
                            delay: 5000,
                        });
                        setTimeout(function () {
                            location.reload();
                        }, 2500);
                    } else {
                        notifyMe({
                            title: 'Error!',
                            msg: response.msg,
                            type: 'danger',
                            delay: 5000,
                        });
                    }
                },
                complete: function () {
                    preloader.hide();
                }
            });
        }
    }

    /**
     *  SMS Blaster
     *
     **/
    function removeSmsErros() {
        $('#sms-error-box').find('p').remove();
        $('input, textarea').removeClass('errorBd is-invalid');
        $('#sms-error-box').hide();
    }

    function countCharacters() {
        count = $(this).val().length;
        $('#charCount').text(count);
    }

    function onSmsSend() {
        var btn = $(this);
        var recipient = $('#smsRecipient');
        var message = $('#smsMessage');
        var errContainer = $('#sms-error-box');
        var smsPreloader = $('#smsPreloader');
        var error = 0;
        removeSmsErros();

        if (recipient.val() == '') {
            recipient.addClass('errorBd is-invalid');
            errContainer.append('<p class="mb-0">* Recipient is required</p>');
            error++;
        } else {
            if (!jmrValidator(recipient.val()).isNumber()) {
                recipient.addClass('errorBd is-invalid');
                errContainer.append('<p class="mb-0">* Please input a number</p>');
                error++;
            } else {
                if (recipient.val().length < 10) {
                    recipient.addClass('errorBd is-invalid');
                    errContainer.append('<p class="mb-0">* Please input a 10 digit number</p>');
                    error++;
                }

            }
        }

        if (message.val() == '') {
            message.addClass('errorBd is-invalid');
            errContainer.append('<p class="mb-0">* Message is required</p>');
            error++;
        } else {
            if (message.val().length > 300) {
                message.addClass('errorBd is-invalid');
                errContainer.append('<p class="mb-0">* You have reached the maximum character limit. Please make your message shorter.</p>');
                error++;
            }
        }

        if (error > 0) errContainer.show();
        else {
            var data = {
                recipient: recipient.val(),
                message: message.val(),
            };

            if (smsXhr && smsXhr.readyState != 4) smsXhr.abort();
            smsXhr = $.ajax({
                type: "POST",
                url: basePath + 'announcement/index/send-sms',
                data: data,
                beforeSend: function () {
                    btn.prop('disabled', true);
                    $('#resetSmsForm').prop('disabled', true);
                    smsPreloader.show();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    if (response.status == 1) {
                        notifyMe({
                            title: 'Success!',
                            msg: response.msg,
                            type: 'success',
                            delay: 5000,
                        });
                        setTimeout(function () {
                            location.reload();
                        }, 2500);
                    } else {
                        notifyMe({
                            title: 'Error!',
                            msg: response.msg,
                            type: 'danger',
                            delay: 5000,
                        });
                    }
                },
                complete: function () {
                    btn.prop('disabled', false);
                    $('#resetSmsForm').prop('disabled', false);
                    smsPreloader.hide();
                }
            });
        }
    }

    function init() {

        if (typeof current_controler != "undefined" && current_controller != 'Announcement') return;

        $('#sendAnnouncement').on('click', onSend);
        $('#body').keyup(countCharacters);

        // sms blaster
        $('#smsMessage').keyup(countCharacters);
        $('#sendSmsBlast').click(onSmsSend);
        $('#resetSmsForm').click(function () {
            location.reload();
        });
    }

    $(document).ready(init);
}(jQuery));