(function ($) {
    var sectionContainer = $('.has-section');
    var noSection = $('.no-section');
    var subjectContainer = $('.has-subject');
    var noSubject = $('.no-subject');
    var studentNameInput = $('#studentName');
    var userList = $('#user-result-list');
    var userSearchContainer = $('.user-search-result');
    var userResultSet = [];
    var xhr;
    var xhr2;

    function hideErrors() {
        $('div, input, select, li').removeClass('errorBd');
        $('p.text-danger').remove();
        $('.errorMsg').remove();
        $('.s-msg').remove();
        $('.e-msg').remove();
    }

    function addNewSubject() {
        var template = $('#subjectClone li').clone(true);
        subjectContainer.find('ul').prepend(template);

        subjectContainer.show();
        noSubject.hide();

        // disable adding new row while there is existing edit
        $(this).prop('disabled', true);
    }

    function onSubjectEdit() {
        var _this = $(this);
        _this.closest('li').find('.subject-text')
            .attr('contenteditable', true)
            .addClass('active-edit')
            .focus();
        _this.closest('li').find('table tr').addClass('active-edit-bd');

        _this.hide();
        _this.parent().find('.save-subject-btn').show();
        _this.parent().find('.cancel-edit-subject-btn').show();
        _this.parent().find('.archive-subject-btn').hide();

        // disable adding new row
        $('#addNewSubjectBtn').prop('disabled', true);

        // disable editing other row
        $('.edit-subject-btn').not(this).off('click');
    }

    function onSubjectSave() {
        var _this = $(this);
        var name = _this.closest('li').find('.subject-text').text();
        var id = _this.closest('li').attr('data-id');
        var level_id = $('#levelName').attr('data-id');
        var data = {
            id: id,
            name: name,
            level_id: level_id,
        };

        if (name == '') {
            _this.closest('li').addClass('errorBd');
            noSubject.after('<p class="errorMsg">* Name is required.</p>');
        } else {
            if (xhr2 && xhr2.readyState != 4) {
                xhr2.abort();
            }

            xhr2 = $.ajax({
                type: "POST",
                url: basePath + 'academic/subject/save',
                data: {data: data},
                beforeSend: function () {
                    hideErrors();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    if (response.status == 1) {
                        _this.hide();
                        _this.parent().find('.edit-subject-btn').show();
                        _this.parent().find('.archive-subject-btn').show();
                        _this.parent().find('.cancel-edit-subject-btn').hide();

                        _this.closest('li')
                            .attr('data-id', response.inserted_id)
                            .find('.subject-text')
                            .attr('contenteditable', false)
                            .removeClass('active-edit is-clone');
                        _this.closest('li table tr').removeClass('active-edit-bd');

                        noSubject.after('<p class="text-success s-msg"><strong>Success!</strong> Subject saved.</p>');

                        // enable adding new row again
                        $('#addNewSubjectBtn').prop('disabled', false);

                        // enable editing again
                        $('.edit-subject-btn').on('click', onSubjectEdit);
                    } else {
                        noSubject.after('<p class="text-danger e-msg">* ' + response.message + '</p>');
                    }
                },
                complete: function () {
                    _this.prop('disabled', false);
                    $('#levelName').removeClass('loading');
                    setTimeout(function () {
                        $('.s-msg').remove();
                        $('.e-msg').remove();
                    }, 3000)
                }
            });
        }
    }

    function onCancelSubjectEdit() {
        var _this = $(this);
        var id = _this.closest('li').attr('data-id');

        if (id) {
            _this.closest('li').find('.subject-text')
                .attr('contenteditable', false)
                .removeClass('active-edit');
            _this.closest('tr').removeClass('active-edit-bd');

            _this.hide();
            _this.parent().find('.edit-subject-btn').show();
            _this.parent().find('.archive-subject-btn').show();
            _this.parent().find('.save-subject-btn').hide();
        } else {
            _this.closest('li').remove();
        }

        // enable adding new row again
        $('#addNewSubjectBtn').prop('disabled', false);

        // enable editing again
        $('.edit-subject-btn').on('click', onSubjectEdit);

    }

    function onArchiveSubject() {
        var _this = $(this);
        var id = $(this).closest('li').attr('data-id');
        var status = $(this).attr('data-status');
        var newStatus = status == 1 ? 0 : 1;
        var newIcon = newStatus == 1 ? 'fab fa-get-pocket text-info' : 'fas fa-archive text-danger';
        var oldIcon = status == 1 ? 'fab fa-get-pocket text-info' : 'fas fa-archive text-danger';

        if (xhr && xhr.readyState != 4) {
            xhr.abort();
        }

        xhr = $.ajax({
            type: "POST",
            url: basePath + 'academic/subject/archive',
            data: {id: id, is_archive: newStatus},
            beforeSend: function () {
                hideErrors();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            success: function (response) {
                if (response.status == 1) {
                    _this.attr('data-status', newStatus);
                    _this.find('i').removeClass(oldIcon).addClass(newIcon);

                    noSubject.after('<p class="text-success s-msg"><strong>Success!</strong> Subject status changed.</p>');
                }
            },
            complete: function () {
                setTimeout(function () {
                    $('.s-msg').remove();
                }, 3000)
            }
        });
    }

    function getSubject(id) {
        if (id) {
            if (xhr2 && xhr2.readyState != 4) {
                xhr2.abort();
            }

            xhr2 = $.ajax({
                type: 'get',
                url: basePath + 'academic/query?type=subject&level=' + id,
                beforeSend: function () {
                    noSubject.hide();
                    subjectContainer.hide();
                    subjectContainer.find('ul').empty();
                    $('.s-pre-loader').show();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    if (response.subjects != "undefined") {
                        if (response.subjects.length > 0) {
                            $.each(response.subjects, function (i, e) {
                                var template = $('#subjectClone li').clone(true);

                                template.attr('data-id', e.id);
                                template.find('.subject-text')
                                    .removeClass('active-edit is-clone')
                                    .attr('contenteditable', false)
                                    .text(e.name);
                                template.find('table tr').removeClass('active-edit-bd');

                                template.find('.edit-subject-btn').show();
                                template.find('.save-subject-btn').hide();
                                template.find('.cancel-edit-subject-btn').hide();
                                template.find('.archive-subject-btn').attr('data-status', e.is_archive);
                                template.find('.archive-subject-btn').show();

                                if (e.is_archive == 1) template.find('.archive-subject-btn').find('i').addClass('fa-get-pocket text-info');
                                else template.find('.archive-subject-btn').find('i').addClass('fa-archive text-danger');


                                subjectContainer.find('ul').append(template);
                            });
                            subjectContainer.show();
                            noSubject.hide();
                        } else {
                            noSubject.show();
                            subjectContainer.hide();
                        }
                    }
                },
                complete: function () {
                    $('.s-pre-loader').hide();
                }
            });
        }
    }

    function addNewSection() {
        var template = $('#sectionClone li').clone(true);
        sectionContainer.find('ul').prepend(template);

        sectionContainer.show();
        noSection.hide();

        // disable adding new while there is existing editable new row
        $(this).prop('disabled', true);

    }

    function onSectionEdit() {
        var _this = $(this);
        _this.closest('li').find('.section-text')
            .attr('contenteditable', true)
            .addClass('active-edit')
            .focus();
        _this.closest('li').find('table tr').addClass('active-edit-bd');

        _this.hide();
        _this.parent().find('.save-section-btn').show();
        _this.parent().find('.cancel-edit-btn').show();
        _this.parent().find('.archive-section-btn').hide();

        // disable adding new row
        $('#addNewSectionBtn').prop('disabled', true);

        // disable editing other row
        $('.edit-section-btn').not(this).off('click');
    }

    function onSectionSave() {
        var _this = $(this);
        var name = _this.closest('li').find('.section-text').text();
        var id = _this.closest('li').attr('data-id');
        var level_id = $('#levelName').attr('data-id');
        var data = {
            id: id,
            name: name,
            level_id: level_id,
        };

        if (name == '') {
            _this.closest('li').addClass('errorBd');
            noSection.after('<p class="errorMsg">* Name is required.</p>');
        } else {
            if (xhr && xhr.readyState != 4) {
                xhr.abort();
            }

            xhr = $.ajax({
                type: "POST",
                url: basePath + 'academic/section/save',
                data: {data: data},
                beforeSend: function () {
                    hideErrors();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    if (response.status == 1) {
                        _this.hide();
                        _this.parent().find('.edit-section-btn').show();
                        _this.parent().find('.archive-section-btn').show();
                        _this.parent().find('.cancel-edit-btn').hide();
                        _this.parent().find('.view-schedule-btn').show();

                        _this.closest('li')
                            .attr('data-id', response.inserted_id)
                            .find('.section-text')
                            .attr('contenteditable', false)
                            .removeClass('active-edit');
                        _this.closest('li table tr').removeClass('active-edit-bd');

                        noSection.after('<p class="text-success s-msg"><strong>Success!</strong> Section saved.</p>');

                        // enable adding new row again
                        $('#addNewSectionBtn').prop('disabled', false);

                        // enable editing again
                        $('.edit-section-btn').on('click', onSectionEdit);
                    } else {
                        noSection.after('<p class="text-danger e-msg">* ' + response.message + '</p>');
                    }
                },
                complete: function () {
                    _this.prop('disabled', false);
                    $('#levelName').removeClass('loading');
                    setTimeout(function () {
                        $('.s-msg').remove();
                        $('.e-msg').remove();
                    }, 3000)
                }
            });
        }
    }

    function onCancelSectionEdit() {
        var _this = $(this);
        var id = _this.closest('li').attr('data-id');

        if (id) {
            _this.closest('li').find('.section-text')
                .attr('contenteditable', false)
                .removeClass('active-edit');
            _this.closest('tr').removeClass('active-edit-bd');

            _this.hide();
            _this.parent().find('.save-section-btn').hide();
            _this.parent().find('.edit-section-btn').show();
            _this.parent().find('.archive-section-btn').show();
        } else {
            _this.closest('li').remove();
        }

        // enable adding new row again
        $('#addNewSectionBtn').prop('disabled', false);

        // enable editing again
        $('.edit-section-btn').on('click', onSectionEdit);
    }

    function onArchiveSection() {
        var _this = $(this);
        var id = $(this).closest('li').attr('data-id');
        var status = $(this).attr('data-status');
        var newStatus = status == 1 ? 0 : 1;
        var newIcon = newStatus == 1 ? 'fab fa-get-pocket text-info' : 'fas fa-archive text-danger';
        var oldIcon = status == 1 ? 'fab fa-get-pocket text-info' : 'fas fa-archive text-danger';

        if (xhr && xhr.readyState != 4) {
            xhr.abort();
        }

        xhr = $.ajax({
            type: "POST",
            url: basePath + 'academic/section/archive',
            data: {id: id, is_archive: newStatus, archive_section: true},
            beforeSend: function () {
                hideErrors();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            success: function (response) {
                if (response.status == 1) {
                    _this.attr('data-status', newStatus);
                    _this.find('i').removeClass(oldIcon).addClass(newIcon);

                    noSection.after('<p class="text-success s-msg"><strong>Success!</strong> Section status changed.</p>');
                }
            },
            complete: function () {
                setTimeout(function () {
                    $('.s-msg').remove();
                }, 3000)
            }
        });
    }

    function getSection(id) {
        if (id) {
            if (xhr && xhr.readyState != 4) {
                xhr.abort();
            }

            xhr = $.ajax({
                type: 'get',
                url: basePath + 'academic/query?type=section&level=' + id,
                beforeSend: function () {
                    noSection.hide();
                    sectionContainer.hide();
                    sectionContainer.find('ul').empty();
                    $('.pre-loader').show();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {

                    if (typeof response.sections != "undefined") {
                        if (response.sections.length > 0) {
                            $.each(response.sections, function (i, e) {
                                var template = $('#sectionClone li').clone(true, true);
                                var schedule_url = template.find('.view-schedule-btn a').attr('href');

                                template.attr('data-id', e.id);
                                template.find('.section-text')
                                    .removeClass('active-edit is-clone')
                                    .attr('contenteditable', false)
                                    .text(e.name);
                                template.find('table tr').removeClass('active-edit-bd');

                                template.find('.edit-section-btn').show();
                                template.find('.save-section-btn').hide();
                                template.find('.cancel-edit-btn').hide();
                                template.find('.archive-section-btn').attr('data-status', e.is_archive);
                                template.find('.archive-section-btn').show();

                                template.find('.view-schedule-btn a').attr('href', schedule_url + '?level=' + id + '&section=' + e.id);
                                template.find('.view-schedule-btn').show();

                                if (e.is_archive == 1) template.find('.archive-section-btn').html('<i class="fab fa-get-pocket text-info"></i>');
                                else template.find('.archive-section-btn').html('<i class="fas fa-archive text-danger"></i>');


                                sectionContainer.find('ul').append(template);
                            });
                            sectionContainer.show();
                            noSection.hide();
                        } else {
                            noSection.show();
                            sectionContainer.hide();
                        }
                    }
                },
                complete: function () {
                    $('.pre-loader').hide();
                }
            });
        }
    }

    function onLevelSave() {
        var _this = $(this);
        var id = $('#levelName').attr('data-id');
        var name = $('#levelName').val();

        var data = {
            id: id ? id : '',
            name: name,
        };

        if (name == '') {
            $('#levelName')
                .addClass('errorBd')
                .after('<p class="text-danger">* This is required.</p>');

        } else {
            if (xhr && xhr.readyState != 4) {
                xhr.abort();
            }

            xhr = $.ajax({
                type: "POST",
                url: basePath + 'academic/grade-levels/save',
                data: {data: data},
                beforeSend: function () {
                    hideErrors();
                    _this.prop('disabled', true);
                    $('#levelName').addClass('loading');
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    var template = $('#levelClone tr').clone(true);
                    var rowCount = $('#levelTable tbody tr').length;

                    if (response.status == 1) {

                        if (response.mode == 1) {
                            if (response.inserted_id != null) id = response.inserted_id;
                            template.attr('data-id', id);
                            template.find('.level-name').text(name);
                            template.find('.tbl-count').text(rowCount + 1);

                            $('#levelName').attr('data-id', '').val('');
                            $('#levelTable tbody').prepend(template);

                            notifyMe({
                                title: 'Success!',
                                msg: response.message,
                                type: 'success',
                                delay: 5000,
                            });
                            setTimeout(function () {
                                location.reload();
                            }, 2000);
                        }

                        if (response.mode == 2) {
                            $('#levelTable tbody tr[data-id="' + response.inserted_id + '"]').find('.level-name').text(name);
                            $('#levelName').attr('data-id', '').val('');

                            notifyMe({
                                title: 'Success!',
                                msg: response.message,
                                type: 'success',
                                delay: 5000,
                            });

                            setTimeout(function () {
                                location.reload();
                            }, 2000)
                        }
                    } else {
                        notifyMe({
                            title: 'Error!',
                            msg: 'Oops something went wrong. Reload the page and try again.',
                            type: 'danger',
                            delay: 5000,
                        });
                    }
                },
                complete: function () {
                    _this.prop('disabled', false);
                    $('#levelName').removeClass('loading');
                }
            });
        }

    }

    function onLevelEdit() {
        var id = $(this).closest('tr').attr('data-id');
        var name = $(this).closest('tr').find('.level-name').text();

        $('#levelName')
            .attr('data-id', id)
            .val(name);
        $('#addNewSectionBtn').attr('disabled', false);
        $('#addNewSubjectBtn').attr('disabled', false);
        getSection(id);
        getSubject(id);
    }

    function onArchiveLevel() {
        var _this = $(this);
        var id = $(this).closest('tr').attr('data-id');
        var status = $(this).attr('data-status');
        var newStatus = status == 1 ? 0 : 1;

        if (xhr && xhr.readyState != 4) xhr.abort();
        xhr = $.ajax({
            type: "POST",
            url: basePath + 'academic/grade-levels/archive',
            data: {id: id, is_archive: newStatus},
            beforeSend: function () {
                hideErrors();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            success: function (response) {
                if (response.status == 1) {
                    _this.attr('data-status', newStatus);
                    if (newStatus) {
                        _this.find('.l-ret').show();
                        _this.find('.l-arc').hide();
                    } else {
                        _this.find('.l-ret').hide();
                        _this.find('.l-arc').show();
                    }

                    notifyMe({
                        title: 'Success!',
                        msg: response.message,
                        type: 'success',
                        delay: 5000,
                    });
                } else {
                    notifyMe({
                        title: 'Error!',
                        msg: response.message,
                        type: 'danger',
                        delay: 5000,
                    });
                }
            },
            complete: function () {
            }
        });
    }

    function onUserSearch() {
        var _this = $(this);
        var val = _this.val().trim();
        var result;
        userResultSet = [];

        _this.attr('data-id', '');
        userList.empty();

        if (xhr && xhr.readyState != 4) {
            xhr.abort();
        }

        if (val.length < 3) {
            userSearchContainer.hide();
            $('.errorMsg').remove();
        }

        _this.autocomplete({
            minLength: 3,
            source: function (request, response) {
                var term = $.trim(request.term);
                var data = {
                    keyword: term,
                    user_search: true,
                };

                xhr = $.ajax({
                    type: "POST",
                    data: data,
                    url: 'functions/academicManager.php',
                    beforeSend: function () {
                        _this.addClass('.loading');
                        userSearchContainer.hide();
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    },
                    success: function (response) {
                        result = $.parseJSON(response);
                        if (result.status != null && result.status == 404) {
                            userList.html('<li> No result for "' + _this.val() + '"</li>');
                            userList.css('pointerEvents', 'none');
                        } else {
                            if (result.data != null) {
                                $.each(result.data, function (i, e) {
                                    var middle_name = e.middle_name != null ? e.middle_name : '';
                                    var user_name = e.first_name + ' ' + middle_name + ' ' + e.last_name;
                                    e.cid = data.keyword;
                                    e.user_name = user_name;

                                    userResultSet.push(e);
                                    userList.append('<li class="u-result" data-key="' + i + '" data-id="' + e.id + '">' + user_name + '</li>');
                                });
                            }
                            userList.css({'pointerEvents': 'auto', 'cursor': 'pointer'});
                        }

                        userSearchContainer.show();
                        $('.u-result').on('click', onUserResultClick);
                    },
                    complete: function () {
                        _this.removeClass('.loading');
                        if (userResultSet.length == 1) onUserResultClick();
                    },
                });
            }
        });
    }

    function onUserResultClick() {
        var term = '';
        var selection = '';
        var selectContainer = $('#schoolTermInstance');
        var subjectSelect = $('#subjectName');
        var ind = $(this).attr('data-key');
        if (typeof ind == 'undefined') ind = 0;

        var selected = userResultSet[ind];
        if (selected != null) {
            studentNameInput.val(selected['user_name']);
            studentNameInput.attr('data-id', selected['id']);
            userSearchContainer.hide();
            selectContainer.empty('');

            switch (selected['term']) {
                case '1':
                    term = 'Quarterly';
                    selection = $('#termInstanceClone select#termQuarterly option').clone();
                    break;
                case '2':
                    term = 'Bi-Semester';
                    selection = $('#termInstanceClone select#termBiSem option').clone();
                    break;
                case '3':
                    term = 'Bi-Semester';
                    selection = $('#termInstanceClone select#termTriSem option').clone();
                    break;
                default:
                    selection = '<option value="">-- Select --</option>';
                    break;
            }

            if (selected['subjects'].length > 0) {
                subjectSelect.empty();
                subjectSelect.append('<option value="">-- Select --</option>');

                $.each(selected['subjects'], function (i, e) {
                    subjectSelect.append('<option value="' + e.id + '">' + e.name + '</option>');
                });
            }
            $('#schoolTerm').attr('data-id', selected['term']).val(term);
            selectContainer.html(selection);
        }

    }

    function onSaveGrade(e) {
        e.preventDefault();
        var _this = $(this);
        var record_id = $('#gradeRecordId');
        var subject = $('#subjectName');
        var term = $('#schoolTerm');
        var term_instance = $('#schoolTermInstance');
        var school_year = $('#schoolYear');
        var grade = $('#studentGrade');
        var graded_by = $('#gradedBy');
        var remarks = $('#remarks');
        var error = 0;

        $('.grade-sheet .is-required').each(function (i, e) {
            var value = $(e).val();
            if (value == '') {
                $(e).addClass('errorBd');
                error++;
            } else $(e).removeClass('errorBd');
        });

        if (error > 0) {
            $('#gradSheetErrorBox').show();
        } else {
            $('#gradSheetErrorBox').hide();

            if (xhr && xhr.readyState != 4) {
                xhr.abort();
            }

            xhr = $.ajax({
                type: "POST",
                data: {
                    id: record_id.val(),
                    student_id: studentNameInput.attr('data-id'),
                    subject: subject.val(),
                    term_id: term.attr('data-id'),
                    term_instance: term_instance.val(),
                    school_year: school_year.attr('data-id'),
                    grade: grade.val(),
                    graded_by: graded_by.attr('data-id'),
                    remarks: remarks.val(),
                    save_grade: true,
                },
                url: 'functions/academicManager.php',
                beforeSend: function () {
                    _this.prop('disabled', true);
                    $('.pre-loader').show();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                success: function (response) {
                    var result = $.parseJSON(response);
                    console.log(result);
                    if (result != null) {
                        if (result.status == 4) {
                            $('#gradSheetSuccessBox').show();
                            $('.grade-sheet input, .grade-sheet textarea').val('');
                            $('#schoolTermInstance option').not(':first').remove();

                            setTimeout(function () {
                                $('#gradSheetSuccessBox').hide();
                            }, 3000);
                        }
                    }
                },
                complete: function () {
                    _this.prop('disabled', false);
                    $('.pre-loader').hide();
                },
            });
        }

    }

    function init() {
        if (typeof current_controller != "undefined" && current_controller != 'Academic') return;

        $('#saveLevelBtn').click(onLevelSave);
        $('.editLevelBtn').on('click', onLevelEdit);
        $('.archiveLevelBtn').on('click', onArchiveLevel);
        $('#addNewSectionBtn').click(addNewSection);
        $('.edit-section-btn').on('click', onSectionEdit);
        $('.save-section-btn').on('click', onSectionSave);
        $('.cancel-edit-btn').on('click', onCancelSectionEdit);
        $('.archive-section-btn').on('click', onArchiveSection);
        $('#addNewSubjectBtn').click(addNewSubject);
        $('.edit-subject-btn').on('click', onSubjectEdit);
        $('.save-subject-btn').on('click', onSubjectSave);
        $('.cancel-edit-subject-btn').on('click', onCancelSubjectEdit);
        $('.archive-subject-btn').on('click', onArchiveSubject);
        $('#studentName').keyup(onUserSearch);
        $('#saveGradeBtn').click(onSaveGrade);

        $('#levelName').keyup(function () {
            if ($(this).val() == '') hideErrors();
        });

        $('#levelTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[0, "asc"]],
            "columns": [
                null,
                null,
                {"orderable": false},
            ],
            "language": {
                "emptyTable": "No Results Found."
            }
        });
    }

    $(document).ready(init);
})(jQuery);