(function ($) {
    var dbXhr;

    function onDbChange(select) {
        var db = $(select).val();
        var yearSelect = $('#yearSelect');

        if (dbXhr && dbXhr.readyState != 4) dbXhr.abort();
        dbXhr = $.ajax({
            url: basePath + 'choose-database/get-school-year',
            type: 'POST',
            data: {db: db},
            dataType: 'json',
            beforeSend: function () {
                yearSelect.addClass('loading');
                yearSelect.find('option').not(':first').remove();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            success: function (response) {
                if (response.result.length > 0) {

                    $.each(response.result, function (i, e) {
                        yearSelect.append('<option value="' + e.id + '">' + e.name + '</option>');
                    });
                }
            },
            complete: function () {
                $(select).removeClass('loading');
            },
        });
    }

    function init() {
        if (current_controller != 'ChooseDatabase') return false;

        if ($('#databaseSelect').val() != '') {
            $('#yearSelect').prop('disabled', false);
            $('#selectDatabaseBtn').prop('disabled', false);

            onDbChange($('#databaseSelect'));

        }

        $('#databaseSelect').change(function () {
            if ($(this).val() == '') $('#yearSelect').prop('disabled', true).val('');
            else {
                onDbChange(this);
                $('#yearSelect').prop('disabled', false);
            }
        });

        $('#yearSelect').change(function () {
            if ($(this).val() == '') $('#selectDatabaseBtn').prop('disabled', true).val('');
            else $('#selectDatabaseBtn').prop('disabled', false);
        });
    }

    $(document).ready(init);

}(jQuery));