<?php
if($role !== 'admin') {
    $url = 'dashboard.php?p=profile';
    header('location: '.$url);
}
$users = getData($con, ACCOUNTS_TBL, '1', 'id DESC');
$counter = 1;
?>
<section class="content-header">
    <h1>
        Account Manager
        <small>This is where you manage the users.</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="dashboard.php?p=profile"><i class="fa fa-dashboard"></i>Dashboard</a></li>
        <li class="active">Account Manager</li>
    </ol>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php if(isset($_SESSION['message']) AND $_SESSION['message'] != null): ?>
                <div class="alert alert-success alert-dismissable">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong>Success!</strong> <?php echo $_SESSION['message']; ?>
                </div>
                <?php unset($_SESSION['message']); ?>
            <?php endif; ?>
            <div class="alert alert-success alert-dismissable" id="rp-message" style="display: none">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong>Success!</strong> Admin(s) notified.
            </div>
            <div class="alert alert-success alert-dismissable" id="ac-message" style="display: none">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong>Success!</strong> Access permission changed.
            </div>
            <div class="container-fluid no-padding mb-10">
                <a href="dashboard.php?p=user-form" class="btn btn-primary btn-sm user-btn"><i class="fa fa-plus mr-5"></i> Add New</a>
            </div>
            <div class="box box-default box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">User List</h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="userTable" class="table table-stripped table-hover dataTable">
                            <thead>
                            <th>No.</th>
                            <th>User ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Status</th>
                            <th>Key</th>
                            <th>Actions</th>
                            </thead>
                            <tbody>
                            <?php if(isset($users) AND count($users) > 0): ?>
                                <?php foreach ($users as $key => $value): ?>
                                    <tr data-id="<?php echo $value['id']; ?>">
                                        <td>
                                            <?php echo $counter; $counter++; ?>
                                        </td>
                                        <td>
                                            <?php echo $value['user_id'] ?>
                                        </td>
                                        <td id="tdFullName">
                                            <?php if( !isset($value['middle_name']) AND !empty($value['middle_name']) ): ?>
                                                <?php echo $value['first_name'].' '.$value['middle_name'].'. '.$value['last_name']; ?>
                                            <?php else: ?>
                                                <?php echo $value['first_name'].' '.$value['last_name']; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo !empty($value['email']) ? $value['email'] : '--'; ?>
                                        </td>
                                        <td>
                                            <?php echo $role; ?>
                                        </td>
                                        <td>
                                            <?php echo $value['account_verified'] ? 'Active' : 'Pending'; ?>
                                        </td>
                                        <td>
                                            <?php if(empty($value['temp_key'])): ?>
                                                <i class="fa fa-ban text-muted"></i>
                                            <?php else: ?>
                                                <a class="text-warning tempKey" href="#" data-key="<?php echo $value['temp_key']; ?>"> <i class="fa fa-key"></i></a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="margin collapsible-btn small-sc-btn">
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-default btn-sm">Action</button>
                                                    <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                                        <span class="caret"></span>
                                                        <span class="sr-only">Toggle Dropdown</span>
                                                    </button>
                                                    <ul class="dropdown-menu" role="menu">
                                                        <li>
                                                            <a class="" href="dashboard.php?p=profile&id=<?php echo $value['id']; ?>">EDIT</a>
                                                        </li>
                                                        <li>
                                                            <?php if($value['account_close'] == 0): ?>
                                                                <a class="btn-disable-account" href="#" data-status="<?php echo $value['account_close']; ?>">DISABLE</a>
                                                            <?php else: ?>
                                                                <a class="btn-disable-account" href="#" data-status="<?php echo $value['account_close']; ?>">ENABLE</a>
                                                            <?php endif; ?>
                                                        </li>
                                                        <li>
                                                            <a class="btn-reset-pw" href="#">RESET PASSWORD</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="big-sc-btn">
                                                <a class="btn btn-success btn-sm btn-flat" href="dashboard.php?p=profile&id=<?php echo $value['id']; ?>"><i class="fa fa-pencil"></i> EDIT</a>
                                                <?php if($value['account_close'] == 0): ?>
                                                    <a class="btn btn-danger btn-sm btn-flat btn-disable-account" href="#" data-status="<?php echo $value['account_close']; ?>"><i class="fa fa-ban"></i> DISABLE</a>
                                                <?php else: ?>
                                                    <a class="btn btn-warning btn-sm btn-flat btn-disable-account" href="#" data-status="<?php echo $value['account_close']; ?>"><i class="fa fa-check"></i> ENABLE</a>
                                                <?php endif; ?>
                                                <a class="btn btn-info btn-sm btn-flat btn-reset-pw" href="#"><i class="fa fa-key"></i> RESET PASSWORD</a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="box-footer">
                </div>
            </div>
        </div>
    </div>
</section>
<!-- temp key modal -->
<div id="tempKeyModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-sm">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">User's Temporary Key</h4>
            </div>
            <div class="modal-body">
                <p id="pTempKey"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>