<?php
$currentSchool = [];
$schoolId = '';
if(isset($_GET['id'])) {
    $schoolId = $_GET['id'];
    $profile = getData($con, SCHOOL_TBL, 'id = '.$schoolId);

    if(count($profile)) $currentSchool = current($profile);
}
?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        School Form
        <small>This is where you manage a school account.</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="dashboard.php?p=profile"><i class="fa fa-dashboard"></i>Dashboard</a></li>
        <li class="active"><a href="dashboard.php?p=schools">School</a></li>
        <li class="active">School Form</li>
    </ol>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-8 col-md-offset-2 col-sm-12">
            <div class="box box-default box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo $schoolId !== '' ? 'Edit School' : 'Add School'; ?></h3>
                    <div id="errorBox" class="alert alert-danger alert-dismissable" style="display: none">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <p id="errorRequired" style="display: none">* Fill the required fields.</p>
                        <p id="errorEmailExist" style="display: none">* Email is in use.</p>
                        <p id="errorIdExist" style="display: none">* ID number is in use.</p>
                    </div>
                </div>
                <div class="box-body pd-20">
                    <form id="account-form" method="post" action="functions/accountsManager.php">
                        <input class="hidden" name="form" value="account-form">
                        <input class="hidden" name="currentUser" value="<?php echo $currentUser['id']; ?>">
                        <input class="hidden" name="id" id="schoolId" value="<?php echo isset($schoolId) ? $schoolId : ''; ?>">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="img-container">
                                    <a class="edit-img-btn" href="#" data-toggle="tooltip" title="Change image"><i class="fa fa-pencil-square-o fa-2x text-info"></i></a>
                                    <img id="account-picture" width="200px" class="profile-form-img img-responsive" src="<?php echo isset($currentSchool['picture']) ? $uploadUrl.'/schools/'.$currentSchool['picture'] : 'assets/images/default_image_01.png'; ?>" alt="School Logo" style="margin: 0 auto">
                                    <input class="hidden" name="img-src" id="img-src" value="">
                                    <input class="hidden" name="file-name" id="file-name" value="<?php echo isset($currentSchool['picture']) ? $currentSchool['picture'] : '' ; ?>">
                                    <input class="hidden" name="is-upload" id="isUpload" value="0">
                                    <input class="hidden" type="file" id="upload-account-picture">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="first-name">Name</label>
                                    <input type="text" name="school-name" class="form-control req" placeholder="* Enter name.." value="<?php echo isset($currentSchool['name']) ? $currentSchool['name'] : ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="first-name">Short Name</label>
                                    <input type="text" name="school-short-name" class="form-control req" placeholder="* Enter short name.." value="<?php echo isset($currentSchool['short_name']) ? $currentSchool['short_name'] : ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="email">Email</label>
                                    <input type="email" name="email" class="form-control req" placeholder="* Enter email.." value="<?php echo isset($currentSchool['email']) ? $currentSchool['email'] : ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="phone">Mobile/Telephone</label>
                                    <input type="text" name="phone" class="form-control" placeholder="* Enter Telephone number.." value="<?php echo isset($currentSchool['phone']) ? $currentSchool['phone'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="address">Address</label>
                                    <input type="text" name="address" class="form-control req" placeholder="* Enter address.." value="<?php echo isset($currentSchool['address']) ? $currentSchool['address'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="barangay">Barangay</label>
                                    <input type="text" name="barangay" class="form-control req" placeholder="* Enter barangay.." value="<?php echo isset($currentSchool['barangay']) ? $currentSchool['barangay'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="city">City/Municipality</label>
                                    <input type="text" name="city" class="form-control req" placeholder="* Enter city.." value="<?php echo isset($currentSchool['city']) ? $currentSchool['city'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="province">Province</label>
                                    <input type="text" name="province" class="form-control req" placeholder="* Enter province.." value="<?php echo isset($currentSchool['province']) ? $currentSchool['province'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="postal">Postal</label>
                                    <input type="text" name="postal" class="form-control" placeholder="Enter postal.." value="<?php echo isset($currentSchool['postal']) ? $currentSchool['postal'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <input class="hidden" name="contact_person" id="contactPerson">
                        <div class="row school-contact" data-id="">
                            <div class="col-sm-12">
                                <span><i class="fa fa-info-circle"></i> School Contact Person(s)</span>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <label for="mobile">Contact Person</label>
                                    <input type="text" name="contact_name" class="form-control req contact-name" placeholder="* Enter contact person's name.." value="<?php echo isset($currentSchool['mobile_number']) ? $currentSchool['mobile_number'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <label for="mobile">Mobile Number</label>
                                    <input type="text" name="contact_mobile" class="form-control req contact-mobile" maxlength="10" placeholder="* Enter 10 Digit Mobile number.." value="<?php echo isset($currentSchool['mobile_number']) ? $currentSchool['mobile_number'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <label for="phone">E-mail</label>
                                    <input type="email" name="contact_email" class="form-control req contact-email" placeholder="* Enter a valid email address.." value="<?php echo isset($currentSchool['telephone_number']) ? $currentSchool['telephone_number'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row school-contact" data-id="" >
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <input type="text" name="contact_name" class="form-control contact-name" maxlength="10" placeholder="Enter contact person's name.." value="<?php echo isset($currentSchool['mobile_number']) ? $currentSchool['mobile_number'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <input type="text" name="contact_mobile" class="form-control contact-mobile" maxlength="10" placeholder="Enter 10 Digit Mobile number.." value="<?php echo isset($currentSchool['mobile_number']) ? $currentSchool['mobile_number'] : ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <input type="email" name="contact_email" class="form-control contact-email" placeholder="Enter a valid email address.." value="<?php echo isset($currentSchool['telephone_number']) ? $currentSchool['telephone_number'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-sm-12">
                                <span><i class="fa fa-info-circle"></i> Technical Details</span>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="database-name">Database Name</label>
                                    <input name="database-name" class="form-control req" placeholder="Enter database name.." value="<?php echo isset($currentSchool['database_name']) ? $currentSchool['database_name'] : ''; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="text-center Enter">
                            <button id="saveSchool" type="button" class="btn btn-primary"><i class="fa fa-save"></i> Save Account</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- temp key modal -->
<div id="setupAccountModal" class="modal fade" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Information</h4>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <img class="modal-loader" src="assets/images/CircleBlue.gif">
                    <p>Setting up account. This make take up a few minutes.</p>
                </div>
            </div>
        </div>

    </div>
</div>