<?php
/**
 * @param $schoolId int
 * @param $db array
 */
function setupAccount($schoolId, $db = []) {
    $dbName     = 'pinoypok_comitatus_sch_db'.$schoolId;
    $file       = 'sql-script.txt';
    $tables     = file_get_contents($file);
    $tables     = trim($tables);
    $statements = explode(";", $tables);
    $pass       = '$2y$10$tWcqHE/F/4BFxukSVS1p5u/SKT6LYj.ojckGthDyIp.i8GZc7xUK6';
    $userId     = 'E0'.$schoolId.date('Y').'00001';

    // Create connection
    $conn = new mysqli($db['host'], $db['user'], $db['password']);
    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Create database
    $sql = "CREATE DATABASE $dbName CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
    if ($conn->query($sql) === TRUE) {

        // select the database
        $conn->select_db($dbName);

        // execute queries
        foreach ($statements as $query) {
            if (trim($query) != '') $conn->query($query);
        }

        // insert first user
        $createAdminQuery = "
            INSERT INTO user_accounts (
               user_id,
               first_name,
               last_name,
               password,
               access_permit,
               temp_key,
               modified_by
              ) VALUES (
                $userId,
                'user',
                'user',
                '$pass',
                1,
                'user1234',
                1
              )
          ";
        $conn->query($createAdminQuery);

        // insert app_settings
        $createAppSettings = "INSERT INTO app_settings (school_id, default_theme) VALUES ($schoolId, 'skin-green')";
        $conn->query($createAppSettings);

        // insert first user's settings
        $createUserSettings = "INSERT INTO user_settings (user_id) VALUES (1)";
        $conn->query($createUserSettings);

        // insert default particular (E-Load)
        $createUserSettings = "INSERT INTO payment_particular (name, modified_by) VALUES ('Card Load', 1)";
        $conn->query($createUserSettings);

    } else {
        echo "Error creating database: " . $conn->error;
    }

    $conn->close();
}