<?php
session_start();
if(isset($_SESSION['session_app']) AND $_SESSION['session_app'] == 'school') {
    require_once 'logout.php';
}

if(!isset($_SESSION['user_id'])) {
    header('location: index.php');
}

include 'config/main.config.php';
include 'config/database.config.php';
include '../tools/dataManager.php';
date_default_timezone_set("Asia/Manila");
define('PAGES', 'pages/');

$param          = isset($_GET['p']) ? $_GET['p'] : '';
$target         = $param != '' ? $_GET['p'] : 'profile';
$userId         = $_SESSION['user_id'];
$userType       = $_SESSION['user_role'];
$page_content   = '';
$content        = '';
$role           = '';
$currentUser    = [];

/** set role text */
switch ($userType) {
    case 1:
        $role = 'admin';
        break;
    case 3:
        $role = 'partner';
        break;
    default:
        $role = 'guest';
        break;
}

/** get current user */
$userData = getData($con, ACCOUNTS_TBL, 'id = '.$userId);
if($userType == 3) $userData = getData($con, PARTNER_TBL, 'id = '.$userId);

if($userData) {
    $data = [];
    foreach ($userData as $key => $value) {
        unset($value['password']);
        $data[] = $value;
    }
    if(count($data)) $currentUser = current($data);
}

ob_start();
/** check if the requested page is on the partial folder */
if(file_exists(PAGES."partials/".$target.".php")) {
    $content = PAGES."partials/".$target.".php";
} else { /**  if not, check it on pages folder */
	if (file_exists(PAGES.$target.".php")) $content = PAGES.$target.'.php';
    else header('location: dashboard.php?p=profile');
}

/**
 * get partial pages
 *  main layout
 */
ob_start();
include('layout.php');
$page_content = ob_get_contents();
ob_end_clean();

/** header */
ob_start();
include(PAGES.'partials/header.php');
$output = ob_get_contents();
$page_content = str_replace('!!HEADER!!',  $output, $page_content);
ob_end_clean();

/** left sidebar */
ob_start();
include(PAGES.'partials/left-sidebar.php');
$output1 = ob_get_contents();
$page_content = str_replace("!!LEFT_SIDEBAR!!", $output1 ,$page_content);
ob_end_clean();

/** main content */
ob_start();
include($content);
$output2 = ob_get_contents();
$page_content = str_replace('!!PAGE_CONTENT!!',  $output2, $page_content);
ob_end_clean();

// right sidebar
//ob_start();
//include(PAGES.'partials/right-sidebar.php');
//$output3 = ob_get_contents();
//$page_content = str_replace('!!RIGHT_SIDEBAR!!',  $output3, $page_content);
//ob_end_clean();

// footer
include(PAGES.'partials/footer.php');
$output4 = ob_get_contents();
$page_content = str_replace('!!FOOTER!!',  $output4, $page_content);
ob_end_clean();

echo $page_content;
?>