(function($){

	function onAccountDisable(e) {
		e.preventDefault();
		var button = $(this);
		var id = $(this).closest('tr').attr('data-id');
		var status = $(this).attr('data-status');
		var newClass;
		var oldClass;
		var newIcon;
		var oldIcon;
		var label;

		if(status == 0) {
			newStatus = 1;
			newClass = 'btn-warning';
			oldClass = 'btn-danger';
			newIcon = 'fa-check';
			oldIcon = 'fa-ban';
			label = 'ENABLE';

		} else {
			newStatus = 0;
			newClass = 'btn-danger';
			oldClass = 'btn-warning';
			newIcon = 'fa-ban';
			oldIcon = 'fa-check';
			label = 'DISABLE'
		}

		var data = {
			disable: true,
			id: id,
			status: newStatus,
		};

		console.log(data);

		if(id) {
			$.ajax({
				type: "POST",
				url: 'functions/profileManager.php',
				data: data,
				beforeSend: function() {
				},
				error: function(jqXHR, textStatus, errorThrown) {
					console.log(textStatus, errorThrown);
				},
				complete: function() {
				},
				success: function (response) {
					var resData = $.parseJSON(response);
					console.log(resData);
					if(resData.status == 'success') {
						button.text('');
						button.prepend('<i class="fa '+ newIcon +'"></i> '+label);
						button.attr('data-status', newStatus);
						button.removeClass(oldClass).addClass(newClass);
						$('#ac-message').show();
						setTimeout(function () {
							$('#ac-message').fadeOut();
						},1500)

					}
				},
			});
		}


	}

	function onAccountResetPassword(e) {
		e.preventDefault();
		var id = $(this).closest('tr').attr('data-id');
        var full_name = $(this).closest('tr').find('#tdFullName').text().trim();

		if(id) {
			$.ajax({
				type: "POST",
				url: 'functions/profileManager.php',
				data: {id: id, fullName: full_name, reset: true},
				error: function(jqXHR, textStatus, errorThrown) {
					console.log(textStatus, errorThrown);
				},
				success: function (response) {
					var resData = $.parseJSON(response);
					console.log(resData);
					if(resData.sent) {
						$('#rp-message').show();
						setTimeout(function () {
							$('#rp-message').fadeOut(1500);
                            location.reload();
						},3000)
					}
				},
			});
		}
	}

	function showTempKey(e) {
		e.preventDefault();
		var tempKey = $(this).attr('data-key');
		console.log(tempKey);
		$('#pTempKey').html('Temporary Key: <strong>'+ tempKey +'</strong>');
		$('#tempKeyModal').modal();
	}

	function init() {
		$('.btn-disable-account').on('click', onAccountDisable);
		$('.btn-reset-pw').on('click', onAccountResetPassword);
		$('.tempKey').on('click', showTempKey);
		$('#userTable').DataTable({
			"paging": true,
			"lengthChange": true,
			"searching": true,
			"ordering": true,
			"info": true,
			"autoWidth": false,
			"columns": [
				null,
				null,
				null,
				null,
				null,
                null,
				{"orderable": false},
				{"orderable": false},
			],
			"language": {
				"emptyTable": "No Results Found."
			},
			"order": [[ 0, "desc" ]]
		});
	}

	$(document).ready(init);
})(jQuery);