(function($){
    var errorBox = $('#errorBox');
    var reqErr = $('#errorRequired');
    var emailExistErr = $('#errorEmailExist');
    var idExistErr = $('#errorIdExist');
    var error = 0;
    var xhr;

    function hideErrors() {
        $('input, div, img').removeClass('errorBd');
        $('.errorMsg').remove();
        errorBox.hide();
        reqErr.hide();
        emailExistErr.hide();
        idExistErr.hide();
        error = 0;
    }

    function onImageChange(e) {
        e.preventDefault();

        console.log(e.currentTarget.files[0]);
        readFile(e.currentTarget.files[0], function(result) {
            $('#user-pp').attr('data-upload', 'true');
            $('#isUpload').val(1);
            $('#file-name').val(e.currentTarget.files[0]['name']);
        });
    }

    function readFile(file, callback) {
        var reader = new FileReader();

        reader.addEventListener('load', function() {
            var result = reader.result;
            $('#user-pp').attr('src', result);
            $('#img-src').val(result);

            callback(result);
        });
        if(file) reader.readAsDataURL(file);
    }

    function validateFields() {
        $('input.req').each(function(){
            var value = $(this).val().trim();
            if(value == '') {
                $(this).addClass('errorBd');
                reqErr.show();
                errorBox.show();
                error++;
            }
        });
    }

    function valueExistValidator() {
        var id = $('input[name="id"]').val();
        var email = $('input[name="email"]').val().trim();

        var data = {
            check_email: true,
            id: id,
            email: email,
        };

        if(xhr && xhr.readyState != 4) {
            xhr.abort();
        }

        xhr = $.ajax({
            type: "POST",
            url: 'functions/requestManager.php',
            data: data,
            error: function(jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            success: function (response) {
                var resData = $.parseJSON(response);
                console.log(resData);
                if(parseInt(resData.email_exist) > 0) {
                    error++;
                    console.log('email in use');
                    $('input[name="email"]').addClass('errorBd');
                    emailExistErr.show();
                    errorBox.show();
                    $('html, body').animate({ scrollTop: errorBox.offset().top-110}, 800);
                }
            },
        });

    }

    function onSave() {
        hideErrors();
        validateFields();
        valueExistValidator();

        console.log(error);
        $(document).ajaxStop(function() {
            // console.log('errors found: ' + error);
            if(error == 0) $('#profile-form').submit();
        });

    }

    function init() {
        $('#saveProfile').on('click', onSave);
        $('.edit-img-btn').on('click', function() {
            $('#upload-user-pp').trigger('click');
        });
        $('#upload-user-pp').on('change', onImageChange);
    }

    $(document).ready(init);
})(jQuery);