(function ($) {
    var errorBox = $('#errorBox');
    var reqErr = $('#errorRequired');
    var error = 0;
    var adXhr;
    var saveAdXhr;

    function hideErrors() {
        $('.errorBd').removeClass('errorBd');
        $('.errorMsg').remove();
        errorBox.hide();
        errorBox.find('p').hide();
        error = 0;
    }

    /** Partner Form & list scripts ***/
    function onImageChange(e) {
        e.preventDefault();

        readFile(e.currentTarget.files[0], function (result) {
            $('.form-img')
                .attr('data-upload', 'true')
                .attr('data-is-placeholder', 0);
            $('#isUpload').val(1);
            $('#file-name').val(e.currentTarget.files[0]['name']);
        });
    }

    function readFile(file, callback) {
        var reader = new FileReader();

        reader.addEventListener('load', function () {
            var result = reader.result;
            $('.form-img').attr('src', result);
            $('#img-src').val(result);

            callback(result);
        });
        if (file) reader.readAsDataURL(file);
    }

    function validateFields() {
        hideErrors();

        $('input.req').each(function () {
            var value = $(this).val().trim();
            if (value == '') {
                $(this).addClass('errorBd');
                reqErr.show();
                errorBox.show();
                error++;
            }
        });

        $('input[type="email"]').each(function () {
            var valid = true;
            var val = $(this).val();

            if (val.length > 0) valid = jmrValidator(val).isEmail();
            if (!valid) {
                $(this)
                    .addClass('errorBd')
                    .after('<p class="errorMsg">* Please input a valid email.</p>');
                error++;
            }

        });
    }

    function onSave() {
        validateFields();
        if (error == 0) $('#partner-form').submit();
    }

    /** end -- Partner Form & list scripts ***/

    /** Partner Ad Form & list scripts ***/

    function onSaveAd() {
        validateAdForm();
        if (error == 0) {

            var data = {
                id: $('#partnerAdId').val(),
                partner_name: $('#partnerName').val(),
                title: $('#padTitle').val(),
                description: $('#padDesc').val(),
                url: $('#padUrl').val(),
                duration: $('#padDuration').val(),
                target_audience: JSON.stringify($('.select2').val()),
                file_name: $('#file-name').val(),
                img_src: $('#img-src').val(),
                is_upload: $('#isUpload').val(),
                is_banner: $('.ad-type:checked').val(),
                form: 'partner-ad-form'
            };
            console.log('adf', data);

            if (saveAdXhr && adXhr.readyState != 4) saveAdXhr.abort();

            saveAdXhr = $.ajax({
                type: "POST",
                url: 'functions/partnerManager.php',
                data: data,
                beforeSend: function () {
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                },
                complete: function () {
                },
                success: function (response) {
                    var resData = $.parseJSON(response);
                    console.log(resData);
                    if (resData.status == 'success') {
                        $('.s-msg').text(resData.msg);
                        $('#successBox').show();
                        $('html, body').animate({scrollTop: $('#successBox').offset().top - 110}, 800);
                        setTimeout(function() {
                            window.location.replace('dashboard.php?p=partner-ads');
                        }, 3000);
                    } else {
                        if (typeof resData.msg.err_dimension != "undefined") $('#errorDimension').show();
                        if (typeof resData.msg.err_mime != "undefined") $('#errorMime').show();
                        $('#errorBox').show();
                    }
                },
            });
        }
    }

    function validateAdForm() {
        hideErrors();
        var desc = $('#padDesc').val().trim();
        var url = $('#padUrl').val().trim();
        var target_audience = $('.select2');

        $('.req').each(function () {
            var value = $(this).val().trim();
            if (value == '') {
                $(this).addClass('errorBd');
                reqErr.show();

                error++;
            }
        });

        if (jmrValidator(desc, 0, 450).stringTooLong()) {
            $('#errorAdDesc').show();
            $('#padDesc').addClass('errorBd');
            error++;
        }


        if(url.length) {
            if (!jmrValidator(url).isValidUrl()) {
                $('#errorAdUrl').show();
                $('#padUrl').addClass('errorBd');
                error++;
            }
        }

        if(target_audience.val() == null) {
            target_audience.addClass('errorBd');
            reqErr.show();
            error++;
        }


        if (error > 0) errorBox.show();
    }

    function onAdChangeStatus(e) {
        e.preventDefault();
        var button = $(this);
        var id = button.closest('tr').attr('data-id');
        var status = button.attr('data-pub');
        var newClass;
        var newStatus;

        if (status == 0) {
            newStatus = 1;
            newClass = 'fa-eye fa-lg';
        } else {
            newStatus = 0;
            newClass = 'fa-eye-slash fa-lg';
        }

        var data = {
            id: id,
            is_publish: newStatus,
            publish_ad: true,
        };

        console.log(data);

        if (adXhr && adXhr.readyState != 4) adXhr.abort();

        adXhr = $.ajax({
            type: "POST",
            url: 'functions/partnerManager.php',
            data: data,
            beforeSend: function () {
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            },
            complete: function () {
            },
            success: function (response) {
                var resData = $.parseJSON(response);
                console.log(resData);
                if (resData.status == 'success') {
                    console.log('here');
                    button.attr('data-pub', newStatus);
                    button.empty();
                    button.html('<i class="fa ' + newClass + '"></i>');
                    $('#adPubMsg').show();
                    setTimeout(function () {
                        $('#adPubMsg').fadeOut();
                    }, 3000)

                }
            },
        });
    }

    /** end -- Partner Ad Form & list scripts ***/

    function init() {
        $('#savePartner').click(onSave);
        $('.edit-img-btn').click(function () {
            $('#upload-account-picture').trigger('click');
        });
        $('#upload-account-picture').change(onImageChange);

        /** for ads **/
        $('#savePartnerAd').click(onSaveAd);
        $('.edit-ad-img-btn').click(function () {
            $('#upload-account-picture').trigger('click');
        });
        $('#upload-account-picture').change(onImageChange);
        $('.publish-ad-btn').on('click', onAdChangeStatus);

        // dataTables
        $('#partnersTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "columns": [
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                {"orderable": false},
            ],
            "language": {
                "emptyTable": "No Results Found."
            },
            "order": [[0, "desc"]]
        });

        $('#partnerAdsTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "columns": [
                {"orderable": false},
                {"orderable": false},
                null,
                null,
                null,
                null,
                null,
                null,
                {"orderable": false},
            ],
            "language": {
                "emptyTable": "No Results Found."
            },
            "order": [[7, "desc"]]
        });

        //Date range picker
        $('#padDuration').daterangepicker();

        // magnific popup
        $('.viewAdBanner').magnificPopup({
            type: 'image'
        });

        // ads select
        $('.select2').select2();
        if(typeof targetId != "undefined") {
            $.each(targetId.split(','), function (i, e) {
                var option = $("#adAudience option[value='" + e + "']");
                option.prop("selected", true);
                $('.select2-selection__rendered').prepend(
                    '<li class="select2-selection__choice" title="' + option.text() + '">' +
                    '<span class="select2-selection__choice__remove" role="presentation">×</span>'
                    + option.text() + '</li>');
            });

            $('.select2-search__field').css('width', '40px');
        }
    }

    $(document).ready(init);
}(jQuery))