(function ($) {
    var xhr;
    var error = 0;

    function validate() {
        error = 0;
        var username = $('#username').val().trim();
        var password = $('#password').val().trim();

        if(username == '') {
            $('#username').addClass('errorBd');
            error++;
        } else {
            $('#username').removeClass('errorBd');
        }

        if(password == '') {
            $('#password').addClass('errorBd');
            error++
        } else {
            $('#password').removeClass('errorBd');
        }
    }

    function onSignin(e) {
        e.preventDefault();
        validate();
        var errorHolder = $('.error-holder');
        var ajaxLoader  = $('.login-loader-holder');
        errorHolder.find('.errorMsg').text('');
        console.log('error', error);

        if(error == 0) {

            if(xhr && xhr.readyState != 4) {
                xhr.abort();
            }

            xhr = $.ajax({
                url: 'functions/authentication.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    username: $('#username').val().trim(),
                    password: $('#password').val().trim(),
                },
                beforeSend: function () {
                    ajaxLoader.show();
                    errorHolder.hide();
                },
                success: function(data) {
                    console.log(data);
                    if(data.err_message != null) {
                        errorHolder.find('.errorMsg').text(data.err_message);
                        errorHolder.show();
                    }

                    if(data.status == 4) window.location = 'dashboard.php?p=profile&id='+data.uid;
                },
                error: function (results, sts, err) {
                    console.log(err);
                    console.log(sts)
                },
                complete: function(){
                    ajaxLoader.hide();
                }
            });
        } else {
            errorHolder.find('.errorMsg').text('*Please fill all the fields.');
            errorHolder.show();
        }
    }
    
    function init() {
        $('#signinBtn').click(onSignin);
    }

    $(document).ready(init);
}(jQuery));