(function ($) {
    var xhr;
    var errorHolder = $('.error-holder');
    var ajaxLoader = $('.loader-holder');

    function removeErrors() {
        $('input').removeClass('errorBd');
        $('.text-danger').remove();
    }

    function onForgetPassword(e) {
        e.preventDefault();
        var btn = $(this);
        var email_input = $('#email');

        removeErrors();

        // validate
        if (email_input.val().trim() == '') {
            email_input.addClass('errorBd');
            email_input.after('<small class="text-danger">Please input your email</small>');
        } else {

            if (xhr && xhr.readyState != 4) xhr.abort();
            xhr = $.ajax({
                url: 'functions/profileManager.php',
                type: 'POST',
                dataType: 'JSON',
                data: {email: $('#email').val().trim(), forget_password: true},
                beforeSend: function () {
                    ajaxLoader.show();
                    errorHolder.hide();
                    btn.prop('disabled', true);
                },
                success: function (data) {
                    console.log(data);
                    if (data.status == 0) {
                        email_input.addClass('errorBd');
                        email_input.after('<small class="text-danger">' + data.msg + '</small>');
                    } else {
                        email_input.val('');
                        alert('Success! The system has sent you a recovery password. Please check your email');
                    }

                },
                error: function (results, sts, err) {
                    console.log(err);
                    console.log(sts)
                },
                complete: function () {
                    ajaxLoader.hide();
                    btn.prop('disabled', false);

                }
            });
        }
    }

    function init() {
        $('#submitBtn').click(onForgetPassword);
    }

    $(document).ready(init);
}(jQuery));