<?php

function test_input($data) {
  $data = trim($data);
  $data = stripslashes($data);
  $data = htmlspecialchars($data);
  return $data;
}

function validatePassword($string1, $string2) {

	$errors = array();

	if($string1 != $string2) $errors['passwordNotMatch'] = '* Password do not match.';
	if(strlen($string1) < 8) {
		$errors['passwordLengthError'] = '* Password must contain atleast 8 letters';
	} else {
		if(!preg_match("#[0-9]+#",$string1)) $errors['passwordNumericError'] = '* Password must contain atleast 1 number';
		if(!preg_match("#[A-Z]+#",$string1)) $errors['passwordCapitalAlphaError'] = '* Password must contain atleast 1 capital letter';
		if(!preg_match("#[a-z]+#",$string1)) $errors['passwordSmallAlphaError'] = '* Password must contain atleast 1 small letter';
	}

	return $errors;
}

function validateEmail($email) {

	$errors = array();
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
      $errors['invalidEmail'] = "* Invalid email format"; 
    }

    return $errors;
}