<?php

namespace MedicusCms\Controller;

use BaseModule\Controller\BaseController;
use BaseModule\Service\Account\AccountManager;
use MedicusCms\Controller\CmsAction\TemplateAction;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\Mvc\MvcEvent;

class CmsController extends AbstractActionController
{

    /** @var AccountManager */
    public $accountManager;

    /** @var DatabaseService */
    public $databaseService;
    public $paginationApi;

    public function indexAction()
    {
        $controller = $this->params('controller');
        $action = $this->params('action');

        $this->layout()->setVariables([
            'controller' => $controller,
            'action' => $action,
            'params' => $this->params()
        ]);
    }

    public function templateAction()
    {
        $action = new TemplateAction();
        return $action->action($this);
    }

    public function onDispatch(MvcEvent $e)
    {
        $user = $this->authService()->getIdentity();

        // if not authenticated redirect to allowed page
        if(!$user) {
            $redirect = $e->getRequest()->getServer('REQUEST_URI');
            return $this->redirect()->toRoute('base-module/default', array('controller' => 'signin'), array('query' => array('redir' => $redirect)));
        }

        if (!$user &&
            ($user->accessPermit != AccountManager::ACCESS_MANAGER) &&
            ($user->accessPermit != AccountManager::ACCESS_ADMIN) &&
            ($user->accessPermit != AccountManager::ACCESS_QA) &&
            ($user->accessPermit != AccountManager::ACCESS_DEV)
        ) return $this->redirect()->toRoute('base-module/default');

        //$this->databaseService =  $this->serviceLocator->get(DatabaseService::class);
        $this->accountManager = $this->serviceLocator->get(AccountManager::class);
        //$this->paginationApi = $this->serviceLocator->get(Pagination::class);

        return parent::onDispatch($e);
    }


}