<?php
namespace MedicusCms;

use Zend\Mvc\MvcEvent;
use Zend\Stdlib\Glob;
use Zend\Config\Factory;

class Module
{
    public function onBootstrap(MvcEvent $e)
    {
    }

    public function getConfig()
    {
        $config = array();
        $path = sprintf(__DIR__.'/config/{,*.}{global,%s}.php', ENV);
        foreach (Glob::glob($path, Glob::GLOB_BRACE) as $file) {
            $config = array_merge_recursive($config, Factory::fromFile($file));
        }
        return $config;
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ),
            ),
        );
    }
}
