<?php
return array(
    /* Merge all module script to assets directory */
    'rrcom-script-merge' => array (
        'enable' => false,
        'css' => array (
            'default' => array (
                'minify' => true,
                'output' => PUBLIC_PATH.'/assets/css/main.css',
            ),
        ),
        'js' => array(
            'default' => array (
                'minify' => true,
                'output' => PUBLIC_PATH.'/assets/js/main.js',
            ),
        ),
    ),
    'session' => array(
        'config' => array(
            'options' => array(
                'name' => SITE_NAME.'_session',
            ),
        ),
        'db_save_handler_table' => SITE_NAME.'_db_session',
        'auto_create_table' => false,
    ),
    'rrcom-user-account' => array(
        'user-table' => SITE_NAME.'_user_account',
        'auth-db-table' => SITE_NAME.'_auth_db_storage',
        'auto_create_table' => false,
    ),
    'site' => array(
        'name' => 'Medicus Cms',
        'email' => 'mktadmin@gameloft.com',
    ),
    'navigation' => array(
        'all' => array(
            array(
                'label'         => 'My Profile',
                'route'         => 'base-module/default',
                'controller'    => 'profile',
                'order'         => 1,
                'icon'          => 'fa fa-user',
            ),
            array(
                'label'         => 'Account Manager',
                'route'         => 'base-module/default',
                'controller'    => 'account-manager',
                'order'         => 2,
                'icon'          => 'fa fa-users',
                'pages'         => array(
                    array(
                        'label' => 'Accounts',
                        'route' => 'base-module/default',
                        'controller' => 'account-manager',
                        'action' => 'index',
                        'icon' => 'fa fa-circle-o',
                    ),
                ),
            ),
            array(
                'label'         => 'CMS',
                'route'         => 'base-module/default',
                'controller'    => 'cms',
                'order'         => 3,
                'icon'          => 'fa fa-pencil-square-o',
                'pages'         => array(
                    array(
                        'label' => 'Template',
                        'route' => 'base-module/default',
                        'controller' => 'cms',
                        'action' => 'template',
                        'icon' => 'fa fa-circle-o',
                    ),
                ),
            ),
        ),
        'basic' => array(
            array(
                'label'         => 'My Profile',
                'route'         => 'base-module/default',
                'controller'    => 'profile',
                'order'         => 1,
                'icon'          => 'fa fa-user',
            ),
        ),
        'guest' => array(
            array(
                'label'         => 'My Profile',
                'route'         => 'base-module/default',
                'controller'    => 'profile',
                'order'         => 1,
                'icon'          => 'fa fa-user',
            ),
        ),
        'default' => array(
            array(
                'label'         => 'My Profile',
                'route'         => 'base-module/default',
                'controller'    => 'profile',
                'order'         => 1,
                'icon'          => 'fa fa-user',
            ),
        ),
    ),
);