// Include gulp
var gulp = require('gulp');

// Include Our Plugins
var jshint = require('gulp-jshint');
var sass = require('gulp-sass');
var concat = require('gulp-concat');
var uglify = require('gulp-uglify');
var rename = require('gulp-rename');
var minifyCss = require('gulp-minify-css');
var imagemin = require('gulp-imagemin');
var pngquant = require('imagemin-pngquant');
var del = require('del');
var autoprefixer = require('gulp-autoprefixer');
var sourcemaps = require('gulp-sourcemaps');

//Compile & Minify CSS
gulp.task('sass', function () {
    gulp.src(['scss/*.scss', 'scss/**/*.scss'])
    .pipe(sourcemaps.init())
    .pipe(concat('all.scss'))
    .pipe(sass().on('error', sass.logError))
    .pipe(autoprefixer())
    .pipe(minifyCss())
    .pipe(concat('style.css'))
    .pipe(rename({
        basename: 'style',
        extname: '.min.css'
    }))
    .pipe(gulp.dest('dist/css'));
});

// Lint Task
gulp.task('lint', function() {
    return gulp.src('js/*.js')
        .pipe(jshint())
        .pipe(jshint.reporter('default'));
});

// Concatenate & Minify JS
gulp.task('scripts', function() {
    return gulp.src('js/*.js')
      .pipe(concat('all.js'))
      .pipe(rename('all.min.js'))
      .pipe(uglify())
      .pipe(gulp.dest('dist/js'));
});

// // Optimize Images
// gulp.task('image', function() {
//     return gulp.src('images/**/*.*')
//     .pipe(imagemin({
//       progressive: true,
//       use: [pngquant()],
//       svgoPlugins: [{removeViewBox: true}]
//     }))
//     .pipe(gulp.dest('dist/images'));
// });

// //Clean/Delete the Images
// gulp.task('clean-img', function (cb) {
//  return del('dist/images',cb);
//  });


// Watch Files For Changes
gulp.task('watch', function() {
    gulp.watch('js/*.js', ['lint', 'scripts']);
    gulp.watch('scss/*.scss', ['sass']);
    gulp.watch('images/**/*.*', ['clean-img', 'image']);
});

// Default Task
gulp.task('default', ['lint', 'sass', 'scripts', 'watch']);
