<?php

namespace Comitatus\ViewHelper;

use Comitatus\Service\Session\SessionService;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\View\Helper\AbstractHelper;

class SessionHelper extends AbstractHelper implements FactoryInterface
{
    /** @var SessionService */
    protected $sessionHelper;
    
    function __invoke()
    {
        return $this->sessionHelper;
    }
    
    public function createService(ServiceLocatorInterface $helperPluginManager)
    {
        $this->sessionHelper = $helperPluginManager->getServiceLocator()->get(SessionService::class);
        return $this;
    }
}
