<?php

namespace Comitatus\ViewHelper;

use Comitatus\Service\Database\DatabaseService;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\View\Helper\AbstractHelper;

class DatabaseHelper extends AbstractHelper implements FactoryInterface
{
    /** @var DatabaseService */
    protected $databaseHelper;

    function __invoke()
    {
        return $this->databaseHelper;
    }

    public function createService(ServiceLocatorInterface $helperPluginManager)
    {
        $this->databaseHelper = $helperPluginManager->getServiceLocator()->get(DatabaseService::class);
        return $this;
    }
}