<?php

namespace Comitatus\Validator;

use Comitatus\Service\Account\AccountManager;
use Comitatus\Service\Database\DatabaseService;
use Zend\Validator\AbstractValidator;
use Zend\Validator\Exception;

class FieldExistValidator extends AbstractValidator
{
    const VALUE_EXIST = 'valueExist';

    /**
     * Validation failure/success message template definitions
     *
     * @var array
     */
    protected $messageTemplates = array(
        self::VALUE_EXIST => '* Value already exist on the database!',
    );

    protected $options = array(
        'serviceLocator' => null,
        'table'          => null,
        'column'         => null,
    );

    /**
     * Returns true if and only if $value meets the validation requirements
     *
     * If $value fails validation, then this method returns false, and
     * getMessages() will return an array of messages that explain why the
     * validation failed.
     *
     * @param  mixed $value
     * @return bool
     * @throws Exception\RuntimeException If validation of $value is impossible
     */
    public function isValid($value)
    {
        $serviceLocator  = $this->getOption('serviceLocator');
        $databaseService = $serviceLocator->get(DatabaseService::class);
        $accoutnManager  = $serviceLocator->get(AccountManager::class);
        $table           = $this->getOption('table');
        $column          = $this->getOption('column');
        $identifier      = $this->getOption('identifier');

        $record = $accoutnManager->getExistingDataByColumnValue($column, $value, $identifier[0], $identifier[1]);

        if ($record->count()) {
            $this->error(self::VALUE_EXIST);
            return false;
        }

        return true;
    }
}