<?php

namespace Comitatus\Service\SmsManager;

use BaseModule\Service\AbstractBaseService;
use Zend\Http\Client;
use Zend\Http\Request;

class SmsManager extends AbstractBaseService
{
    public function sendSMS($countryCode, $number, $message)
    {
        date_default_timezone_set("Asia/Manila");
        $now    = date("h:i:sa");
        $apiUrl = "https://post.chikka.com/smsapi/request";

        $arr_post_body = array(
            "message_type"  => "SEND",
            "mobile_number" => $countryCode . $number,
            "shortcode"     => "2929077770",
            "message_id"    => uniqid(),
            "message"       => urlencode($message),
            "client_id"     => "d28bfe3cdfa3c35bdb8094f4d4fea1197713cb212a0b4813780324e96362df5a",
            "secret_key"    => "f80f997943e10fdd0cba8c82ce659986e98e697d47c676d3e880da266f39b23a"
        );

        $query_string = "";
        foreach ($arr_post_body as $key => $value) {
            $query_string .= '&' . $key . '=' . $value;
        }

        $client = new Client();
        $curl   = new Client\Adapter\Curl();
        $client->setOptions([
            'maxredirects' => 10,
            'timeout'      => 120,
            'adapter'      => $curl,
            'curloptions'  => array(
                CURLOPT_POST           => 1,
                CURLOPT_RETURNTRANSFER => true,
            ),
        ]);
        $client->setParameterPost($arr_post_body);
        $client->setUri($apiUrl);
        $client->setMethod('post');

        $response = $client->send();
        return json_decode($response->getBody(), true);
    }

    public function sendTextMsg($number, $message)
    {
        $apiUrl  = 'https://www.itexmo.com/php_api/api.php';
        $apiCode = 'DE-CLAIR554949_E8U7R';
        $prefix  = 0;
        $number  = $prefix . $number;
        $data    = [
            '1' => $number,
            '2' => $message,
            '3' => $apiCode
        ];

        $client = new Client();
        $curl   = new Client\Adapter\Curl();
        $client->setOptions([
            'maxredirects' => 10,
            'timeout'      => 120,
            'adapter'      => $curl,
            'curloptions'  => array(
                CURLOPT_POST           => 1,
                CURLOPT_RETURNTRANSFER => true,
            ),
        ]);
        $client->setParameterPost($data);
        $client->setUri($apiUrl);
        $client->setMethod('post');

        $response = $client->send();
        return json_decode($response->getBody(), true);
    }
}