<?php

namespace Comitatus\Service\Database;

use BaseModule\Service\AbstractBaseService;
use Zend\Db\Sql\Sql;
use Zend\Paginator\Adapter\DbSelect;
use Zend\Paginator\Paginator;
use Zend\ServiceManager\ServiceLocatorInterface;

class DatabaseService extends AbstractBaseService
{
    // admin tables
    const ADM_USER_TABLE = 'users_tbl';
    const ADM_SCHOOL_TABLE = 'school_tbl';
    const ADM_SCHOOL_CONTACT_TABLE = 'school_contact_tbl';
    const ADM_PARTNERS_TABLE = 'partners_tbl';
    const ADM_PARTNERS_ADS_TABLE = 'partners_ads_tbl';
    const ADM_PARTNERS_ADS_MAP_TABLE = 'partners_ads_target_map';

    // school tables
    const ALLERGIES_TBL                 = 'allergies';
    const ANNOUNCEMENT_TBL              = 'announcements';
    const APP_SETTINGS_TBL              = 'app_settings';
    const ATTENDANCE_TBL                = 'attendance';
    const CANTEEN_INVENTORY_TBL         = 'canteen_inventory';
    const CANTEEN_TBL                   = 'canteen_items';
    const CANTEEN_SOLD_TBL              = 'canteen_items_sold';
    const CANTEEN_FAC_TBL               = 'canteen_facilities';
    const CANTEEN_FAC_ITEMS_TBL         = 'canteen_items_per_facilities';
    const CANTEEN_END_STOCK_TBL         = 'canteen_end_day_stock_count';
    const DY_SCHEDULE_TBL               = 'daily_schedule';
    const OTP_TBL                       = 'generated_otp';
    const PAYMENT_TBL                   = 'payment_history';
    const PAYMENT_MATRIX_TBL            = 'payment_matrix';
    const PERMISSION_TBL                = 'pages_permission';
    const ACCOUNTS_TBL                  = 'user_accounts';
    const GUARDIAN_TBL                  = 'user_guardian';
    const USER_SETTINGS_TBL             = 'user_settings';
    const USER_WALLET_TBL               = 'user_wallet';
    const WALLET_HISTORY_TBL            = 'user_wallet_history';
    const WALLET_TRANS_TBL              = 'user_wallet_transaction';
    const YR_SCHEDULE_TBL               = 'yearly_schedule';
    const LEVEL_TBL                     = 'grade_levels';
    const SECTION_TBL                   = 'level_section';
    const PAYMENT_SETTINGS_TBL          = 'payment_settings';
    const PAYMENT_SCHEME_TBL            = 'payment_scheme';
    const PAYMENT_PARTICULAR_TBL        = 'payment_particular';
    const GRADES_TBL                    = 'student_grades';
    const SUBJECT_TBL                   = 'level_subject';
    const PARTICULAR_LEVEL_MAP_TBL      = 'particular_level_map';
    const PAYMENT_SCHEME_OPTION_TBL     = 'payment_scheme_options';
    const PAYMENT_USER_MAP_TBL          = 'payment_user_map';
    const SMS_LOGS_TBL                  = 'sms_logs';
    const EMAIL_LOGS_TBL                = 'email_logs';
    const SECTION_SCHEDULE_TBL          = 'schedule_per_section';
    const DISCOUNT_TABLE                = 'discounts';
    const DISCOUNT_PARTICULAR_MAP_TABLE = 'discount_particular_map';
    const ACCESS_LOGS_TABLE             = 'access_logs';
    const REWARDS_TABLE                 = 'reward_table';
    const USER_TABLE                    = 'user_accounts';
    
    public function __construct()
    {
        if (ENV == 'prod') {
        
        }
    }
    
    public function createData($table, $keyValuePair)
    {
        $create = $this->sql->insert();
        $sql    = $create->into($table)->values($keyValuePair);
        $this->sql->prepareStatementForSqlObject($sql)->execute();
        return $lastID = $this->sql->getAdapter()->driver->getLastGeneratedValue();
    }

    public function selectData($table = "", $where = array(), $order = array(), $search = '', $searchColumn = array(), $paginated = false, $limit = 0, $offset = 0)
    {
        $select = $this->sql->select($table);

        if (!empty($search)) {
            foreach ($searchColumn as $key => $column) {
                $operator = $key == 0 ? 'and' : 'or';
                $select->where->$operator->like($table . '.' . $column, '%' . $search . '%');
            }
        }

        if (count($where) > 0)
            $select->where($where);
        if (count($order) > 0)
            $select->order($order);
        if ($limit != 0)
            $select->limit($limit);
        if ($offset != 0)
            $select->offset($limit);

        if ($paginated) {
            $paginatorAdapter = new DbSelect($select, $this->sql);
            return new Paginator($paginatorAdapter);
        }

        return $this->sql->prepareStatementForSqlObject($select)->execute();
    }

    public function updateData($table, $data, $column = 'id')
    {
        $sql = $this->sql->update($table);
        $sql->set($data)
            ->where(array($column => $data[$column]));
        return $this->sql->prepareStatementForSqlObject($sql)->execute();
    }

    public function updateData2($table, $data, $where)
    {
        $sql = $this->sql->update($table);
        $sql->set($data)
            ->where($where);
        return $this->sql->prepareStatementForSqlObject($sql)->execute();
    }

    public function deleteData($table, $data)
    {
        $sql = $this->sql->delete($table);
        $sql->where($data);
        return $this->sql->prepareStatementForSqlObject($sql)->execute();
    }

    public function setDatabase($adapter)
    {
        $this->sql = new Sql($adapter);
    }

    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        return parent::createService($serviceLocator);
    }
    
    public function isTableExist($table)
    {
        $select = $this->sql->select($table);
        $select
            ->columns([1])
            ->limit(1);
        
        $result = $this->sql->prepareStatementForSqlObject($select)->execute();
        
        if ($result !== false) return true;
        else return false;
    }


}