<?php
namespace Comitatus\Form;

use Zend\Form\Form;

class SecureSigninForm extends Form{
    public function __construct($name = null, $options = array())
    {
        parent::__construct('signin', $options);

        $this->add(array(
            'name' => 'signinAccount',
            'type' => 'text',
            'options' => array(
                'label' => 'Email'
            ),
            'attributes' => array(
                'id' => 'UserInput',
                'class' => 'form-username form-control custom-input',
                'placeholder' => 'Email',
            ),
        ));

        $this->add(array(
            'name' => 'signinPassword',
            'type' => 'password',
            'options' => array(
                'label' => 'Password',
            ),
            'attributes' => array(
                'id' => 'PasswordInput',
                'class' => 'form-login-password form-control custom-input',
                'placeholder' => 'Password',
            ),
        ));

        $this->add(array(
            'name' => 'signinRememberMe',
            'type' => 'checkbox',
            'options' => array(
                'label' => 'Remember Me',
                'use_hidden_element' => true,
                'checked_value' => 'yes',
                'unchecked_value' => 'no',
            ),
            'attributes' => array(
                'id' => 'RememberMe',
            ),
        ));

        $this->add(array(
            'name' => 'signinCsrf',
            'type' => 'Zend\Form\Element\Csrf',
            'options' => array(
                'csrf_options' => array(
                    'timeout' => 600
                )
            ),
            'attributes' => array(
                'id' => 'signinCsrf',
            ),
        ));

        $this->add(array(
            'name' => 'submit',
            'type' => 'Submit',
            'attributes' => array(
                'id' => 'SubmitButton',
                'value' => 'Sign in',
                'class' => 'btn btn-primary btn-block btn-flat',
            ),
        ));
    }

}